/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.index.SearcherCache;
import com.atlassian.jira.issue.util.DatabaseIssuesIterable;
import com.atlassian.jira.issue.util.IssueGVsIssueIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class DefaultIndexManager
implements IssueIndexManager {
    private static final Logger log = Logger.getLogger(DefaultIndexManager.class);
    public static final Analyzer ANALYZER_FOR_SEARCHING = JiraAnalyzer.ANALYZER_FOR_SEARCHING;
    public static final Analyzer ANALYZER_FOR_INDEXING = JiraAnalyzer.ANALYZER_FOR_INDEXING;
    public static final String COMMENTS_SUBDIR = "comments";
    public static final String ISSUES_SUBDIR = "issues";
    public static final String PLUGINS_SUBDIR = "plugins";
    private final AtomicInteger indexUpdateCount = new AtomicInteger(0);
    private final AtomicBoolean isOptimizing = new AtomicBoolean();
    private final ReadWriteLock indexLock = new ReentrantReadWriteLock();
    private final IssueIndexer issueIndexer;
    private final IndexPathManager indexPathManager;
    private final IndexingConfiguration indexConfig;
    private final ReindexMessageManager reindexMessageManager;
    private final Supplier<IndexSearcher> issueSearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getIssueSearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };
    private final Supplier<IndexSearcher> commentSearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getCommentSearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };
    private final Supplier<IndexSearcher> changeHistorySearcherSupplier = new Supplier<IndexSearcher>(){

        public IndexSearcher get() {
            try {
                return DefaultIndexManager.this.issueIndexer.getChangeHistorySearcher();
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, DefaultIndexManager.this.indexConfig.isIndexingEnabled());
            }
        }
    };

    public Analyzer getAnalyzerForSearching() {
        return ANALYZER_FOR_SEARCHING;
    }

    public Analyzer getAnalyzerForIndexing() {
        return ANALYZER_FOR_INDEXING;
    }

    public DefaultIndexManager(IndexingConfiguration indexProperties, IssueIndexer issueIndexer, IndexPathManager indexPath, ReindexMessageManager reindexMessageManager) {
        this.indexConfig = (IndexingConfiguration)Assertions.notNull((String)"indexProperties", (Object)indexProperties);
        this.issueIndexer = (IssueIndexer)Assertions.notNull((String)"issueIndexer", (Object)issueIndexer);
        this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPath", (Object)indexPath);
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
    }

    public void deactivate() {
        IssueIndexListener.remove();
        this.indexConfig.disableIndexing();
        this.issueIndexer.shutdown();
        DefaultIndexManager.flushThreadLocalSearchers();
    }

    public long activate(Context context) {
        Assertions.notNull((String)"context", (Object)context);
        if (this.isIndexingEnabled()) {
            throw new IllegalStateException("Cannot activate indexing as it is already active.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activating indexes in '" + this.indexPathManager.getIndexRootPath() + "'."));
        }
        try {
            IssueIndexListener.create();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.indexConfig.enableIndexing();
        return this.reIndexAll(context);
    }

    public boolean isIndexingEnabled() {
        return this.indexConfig.isIndexingEnabled();
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(Context context) {
        Assertions.notNull((String)"context", (Object)context);
        context.setName("Issue");
        log.info((Object)"Reindexing all issues");
        long startTime = System.currentTimeMillis();
        boolean restartScheduler = false;
        Scheduler scheduler = ManagerFactory.getScheduler();
        Awaitable writeLock = new Awaitable(){

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return DefaultIndexManager.this.indexLock.writeLock().tryLock(time, unit);
            }
        };
        if (!this.obtain(writeLock)) {
            return -1L;
        }
        try {
            try {
                if (!scheduler.isShutdown() && !scheduler.isPaused()) {
                    scheduler.pause();
                    restartScheduler = true;
                }
            }
            catch (SchedulerException e) {
                log.warn((Object)"The scheduler is not available, unable to pause it before reindexing.", (Throwable)e);
            }
            this.issueIndexer.deleteIndexes();
            DefaultOfBizDelegator delegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
            DatabaseIssuesIterable issuesIterable = new DatabaseIssuesIterable(delegator, this.getIssueFactory());
            this.issueIndexer.indexIssuesBatchMode((EnclosedIterable<Issue>)issuesIterable, context).await();
            this.optimize0();
            this.reindexMessageManager.clear();
        }
        finally {
            this.indexLock.writeLock().unlock();
            DefaultIndexManager.flushThreadLocalSearchers();
            if (restartScheduler) {
                try {
                    scheduler.start();
                }
                catch (SchedulerException e) {
                    log.error((Object)"Unable to unpause the scheduler after reindex", (Throwable)e);
                }
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ReindexAll took : " + totalTime + "ms"));
        }
        return totalTime;
    }

    public long reIndexIssues(Collection<GenericValue> issues) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext());
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects) throws IndexException {
        Collection genericValues = CollectionUtils.collect(issueObjects, (Transformer)IssueFactory.TO_GENERIC_VALUE);
        return this.reIndexIssues(genericValues);
    }

    public void reIndex(Issue issue) throws IndexException {
        ArrayList issues = Lists.newArrayList((Object[])new Issue[]{issue});
        this.reIndexIssueObjects(issues);
    }

    public void reIndex(GenericValue issueGV) throws IndexException {
        if ("Issue".equals(issueGV.getEntityName())) {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{issueGV});
            this.reIndexIssues(genericValues);
        } else {
            log.error((Object)("Entity is not an issue " + issueGV.getEntityName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexIssues(IssuesIterable issuesIterable, Context context) throws IndexException {
        Assertions.notNull((String)ISSUES_SUBDIR, (Object)issuesIterable);
        Assertions.notNull((String)"context", (Object)context);
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        if (!this.getIndexLock()) {
            log.error((Object)("Could not reindex: " + issuesIterable.toString()));
            return -1L;
        }
        try {
            this.await(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issuesIterable, context));
            this.optimizeIfNecessary(issuesIterable.size());
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            opTimer.end();
        }
        long totalTime = opTimer.snapshot().getMillisecondsTaken();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reindexed " + issuesIterable.size() + " issues in " + totalTime + "ms."));
        }
        return totalTime;
    }

    public int size() {
        return new DatabaseIssuesIterable(new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator()), this.getIssueFactory()).size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @GuardedBy(value="index read lock")
    private void optimizeIfNecessary(int issueNum) throws IndexException {
        try {
            this.indexUpdateCount.addAndGet(issueNum);
            int issuesToForceOptimize = this.indexConfig.getIssuesToForceOptimize();
            int maxReindexes = this.indexConfig.getMaxReindexes();
            if (issuesToForceOptimize > 0 && issueNum >= issuesToForceOptimize) {
                this.optimizeAfterIssuesToForceOptimizeExceeded(issueNum, issuesToForceOptimize);
            } else if (maxReindexes > 0 && this.indexUpdateCount.get() >= maxReindexes) {
                this.optimizeAfterMaxReindexesExceeded(maxReindexes);
            }
        }
        catch (Exception e) {
            throw new IndexException("Error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimizeAfterIssuesToForceOptimizeExceeded(int issueNum, int issuesToForceOptimize) {
        if (this.isOptimizing.compareAndSet(false, true)) {
            try {
                log.info((Object)("Optimizing the index because " + issueNum + " issues were re-indexed in bulk. Threshold is " + issuesToForceOptimize + "."));
                long optimizeTime = this.optimize0();
                log.info((Object)("Optimize index completed in " + optimizeTime + "ms."));
            }
            finally {
                this.isOptimizing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimizeAfterMaxReindexesExceeded(int maxReindexes) {
        if (this.isOptimizing.compareAndSet(false, true)) {
            try {
                log.info((Object)("Optimizing the index because " + this.indexUpdateCount.get() + " issues have been re-indexed since last optimize. Threshold is " + maxReindexes + "."));
                long optimizeTime = this.optimize0();
                log.info((Object)("Optimize index completed in " + optimizeTime + "ms."));
            }
            finally {
                this.isOptimizing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long optimize() {
        if (!this.isIndexingEnabled()) {
            return 0L;
        }
        if (!this.getIndexLock()) {
            return -1L;
        }
        try {
            long l = this.optimize0();
            return l;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    @GuardedBy(value="index read lock")
    private long optimize0() {
        this.indexUpdateCount.set(0);
        long startTime = System.currentTimeMillis();
        this.issueIndexer.optimize().await();
        return System.currentTimeMillis() - startTime;
    }

    public void deIndex(Issue issue) throws IndexException {
        this.deIndex(issue.getGenericValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deIndex(GenericValue entity) throws IndexException {
        if (!"Issue".equals(entity.getEntityName())) {
            log.error((Object)("Entity is not an issue " + entity.getEntityName()));
            return;
        }
        if (!this.getIndexLock()) {
            log.error((Object)("Could not deindex: " + entity.getString("key")));
            return;
        }
        try {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{entity});
            this.await(this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)new IssueGVsIssueIterable(genericValues, this.getIssueFactory()), Contexts.nullContext()));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
    }

    private void await(final Index.Result result) {
        this.obtain(new Awaitable(){

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return result.await(time, unit);
            }
        });
    }

    private void releaseIndexLock() {
        this.indexLock.readLock().unlock();
    }

    boolean getIndexLock() {
        if (StringUtils.isBlank((String)this.indexPathManager.getIndexRootPath())) {
            log.error((Object)"File path not set - not indexing");
            return false;
        }
        return this.obtain(new Awaitable(){

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return DefaultIndexManager.this.indexLock.readLock().tryLock(time, unit);
            }
        });
    }

    private boolean obtain(Awaitable waitFor) {
        try {
            if (waitFor.await(this.indexConfig.getIndexLockWaitTime(), TimeUnit.MILLISECONDS)) {
                return true;
            }
        }
        catch (InterruptedException ie) {
            log.error((Object)"Wait attempt interrupted.", (Throwable)new IndexException("Wait attempt interrupted.", (Exception)ie));
            return false;
        }
        String errorMessage = "Wait attempt timed out - waited " + this.indexConfig.getIndexLockWaitTime() + " milliseconds";
        log.error((Object)errorMessage, (Throwable)new IndexException(errorMessage));
        return false;
    }

    public String getPluginsRootPath() {
        return this.indexPathManager.getPluginIndexRootPath();
    }

    public List<String> getExistingPluginsPaths() {
        String[] listing;
        File pluginRootPath = new File(this.getPluginsRootPath());
        if (pluginRootPath.exists() && pluginRootPath.isDirectory() && pluginRootPath.canRead() && (listing = pluginRootPath.list()) != null) {
            ArrayList<String> subdirs = new ArrayList<String>();
            for (String element : listing) {
                File f = new File(pluginRootPath, element);
                if (!f.exists() || !f.canRead() || !f.isDirectory()) continue;
                subdirs.add(f.getAbsolutePath());
            }
            return Collections.unmodifiableList(subdirs);
        }
        return Collections.emptyList();
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(this.issueIndexer.getIndexPaths());
        paths.addAll(this.getExistingPluginsPaths());
        return Collections.unmodifiableList(paths);
    }

    public IndexSearcher getIssueSearcher() {
        return SearcherCache.getThreadLocalCache().retrieveIssueSearcher(this.issueSearcherSupplier);
    }

    public IndexSearcher getCommentSearcher() {
        return SearcherCache.getThreadLocalCache().retrieveCommentSearcher(this.commentSearcherSupplier);
    }

    public IndexSearcher getChangeHistorySearcher() {
        return SearcherCache.getThreadLocalCache().retrieveChangeHistorySearcher(this.changeHistorySearcherSupplier);
    }

    public void shutdown() {
        DefaultIndexManager.flushThreadLocalSearchers();
        this.issueIndexer.shutdown();
    }

    int getReindexesSinceOptimize() {
        return this.indexUpdateCount.get();
    }

    IssueFactory getIssueFactory() {
        return ComponentManager.getComponentInstanceOfType(IssueFactory.class);
    }

    public String toString() {
        return "DefaultIndexManager: paths: " + this.getAllIndexPaths();
    }

    public static void flushThreadLocalSearchers() {
        try {
            SearcherCache.getThreadLocalCache().closeSearchers();
        }
        catch (IOException e) {
            log.error((Object)("Error while resetting searcher: " + e), (Throwable)e);
        }
    }

    private static interface Awaitable {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;
    }
}

