/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class CommentDocument {
    public static Document getDocument(Comment comment, Issue issue) {
        Document doc = new Document();
        String body = comment.getBody();
        if (body != null) {
            String updateAuthor;
            doc.add((Fieldable)new Field("projid", String.valueOf(issue.getProjectObject().getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("issue_id", String.valueOf(issue.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("id", String.valueOf(comment.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            String author = comment.getAuthor();
            if (author != null) {
                author = CaseFolding.foldUsername((String)comment.getAuthor());
                doc.add((Fieldable)new Field("comment_author", author, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            if ((updateAuthor = comment.getUpdateAuthor()) != null) {
                updateAuthor = CaseFolding.foldUsername((String)comment.getUpdateAuthor());
                doc.add((Fieldable)new Field("comment_update_author", updateAuthor, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            doc.add((Fieldable)new Field("body", body, Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("comment_created", LuceneUtils.dateToString((Date)comment.getCreated()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            Date updated = comment.getUpdated();
            if (updated != null) {
                doc.add((Fieldable)new Field("comment_updated", LuceneUtils.dateToString((Date)updated), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            FieldIndexerUtil.indexKeywordWithDefault(doc, "issue_security_level", issue.getSecurityLevelId(), "-1");
            FieldIndexerUtil.indexKeywordWithDefault(doc, "level", comment.getGroupLevel(), "-1");
            FieldIndexerUtil.indexKeywordWithDefault(doc, "role_level", comment.getRoleLevel() != null ? comment.getRoleLevel().getId() : null, "-1");
            return doc;
        }
        return null;
    }
}

