/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.history.AssigneeDateRangeBuilder;
import com.atlassian.jira.issue.history.DateRangeBuilder;
import com.atlassian.jira.issue.history.PriorityDateRangeBuilder;
import com.atlassian.jira.issue.history.ReporterDateRangeBuilder;
import com.atlassian.jira.issue.history.ResolutionDateRangeBuilder;
import com.atlassian.jira.issue.history.StatusDateRangeBuilder;
import com.atlassian.jira.issue.history.VersionDateRangeBuilder;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfiguration;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;

public class ChangeHistoryFieldConfigurationManager {
    private final LazyReference<Map<String, ChangeHistoryFieldConfiguration>> ref = new LazyReference<Map<String, ChangeHistoryFieldConfiguration>>(){

        protected Map<String, ChangeHistoryFieldConfiguration> create() throws Exception {
            return ChangeHistoryFieldConfigurationManager.this.loadConfiguration();
        }
    };

    private Map<String, ChangeHistoryFieldConfiguration> loadConfiguration() {
        return ImmutableMap.builder().put((Object)"status", (Object)new ChangeHistoryFieldConfiguration(new StatusDateRangeBuilder(), "-1", false)).put((Object)"assignee", (Object)new ChangeHistoryFieldConfiguration(new AssigneeDateRangeBuilder(), "unassigned", false)).put((Object)"reporter", (Object)new ChangeHistoryFieldConfiguration(new ReporterDateRangeBuilder(), "issue_no_reporter", false)).put((Object)"resolution", (Object)new ChangeHistoryFieldConfiguration(new ResolutionDateRangeBuilder(), "-1", false)).put((Object)"priority", (Object)new ChangeHistoryFieldConfiguration(new PriorityDateRangeBuilder(), "-1", false)).put((Object)"fixversion", (Object)new ChangeHistoryFieldConfiguration(new VersionDateRangeBuilder("fixversion", "-1"), "-1", true)).build();
    }

    public Set<String> getAllFieldNames() {
        return ((Map)this.ref.get()).keySet();
    }

    public DateRangeBuilder getDateRangeBuilder(String fieldName) {
        return ((ChangeHistoryFieldConfiguration)((Map)this.ref.get()).get(fieldName)).getDateRangeBuilder();
    }

    public String getEmptyValue(String fieldName) {
        return ((ChangeHistoryFieldConfiguration)((Map)this.ref.get()).get(fieldName)).getEmptyValue();
    }

    public boolean supportsIdSearching(String fieldName) {
        if (((Map)this.ref.get()).get(fieldName) != null) {
            return ((ChangeHistoryFieldConfiguration)((Map)this.ref.get()).get(fieldName)).supportsIdSearching();
        }
        return false;
    }
}

