/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.AbstractFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractVersionsRestFieldOperationsHandler
extends AbstractFieldOperationsHandler<Collection<String>> {
    private final VersionManager versionManager;

    public AbstractVersionsRestFieldOperationsHandler(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    protected Collection<String> getInitialCreateValue() {
        return Collections.emptyList();
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName(), (Object)StandardOperation.ADD.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    @Override
    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        String versionName;
        String versionId = operationValue.asObjectWithProperty("id", this.getFieldName(), errors);
        if (versionId == null && (versionName = operationValue.asObjectWithProperty("name", this.getFieldName(), errors)) != null) {
            Version version = this.versionManager.getVersion(issueCtx.getProjectObject().getId(), versionName);
            if (version != null) {
                versionId = version.getId().toString();
            } else {
                errors.addError(fieldId, "Version name '" + versionName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (versionId == null) {
            return currentFieldValue;
        }
        return Collections2.filter(currentFieldValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)versionId)));
    }

    protected Long[] toVersionIds(Collection<String> ids, ErrorCollection errors) {
        return this.toLongIds(ids, this.getFieldName(), errors);
    }

    @Override
    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        List versionNames;
        HashSet<String> uniqueVersionIds = new HashSet<String>();
        List versionIds = operationValue.asArrayOfObjectsWithId(this.getFieldName(), errors);
        if (versionIds != null) {
            uniqueVersionIds.addAll(versionIds);
        }
        if ((versionNames = operationValue.asArrayOfObjectsWithProperty("name", this.getFieldName(), errors)) != null) {
            for (String versionName : versionNames) {
                Version version = this.versionManager.getVersion(issueCtx.getProjectObject().getId(), versionName);
                if (version != null) {
                    uniqueVersionIds.add(version.getId().toString());
                    continue;
                }
                errors.addError(fieldId, "Version name '" + versionName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        return uniqueVersionIds;
    }

    protected abstract String getFieldName();

    @Override
    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        ArrayList<String> newList;
        String versionId = operationValue.asObjectWithProperty("id", this.getFieldName(), errors);
        if (versionId == null) {
            String versionName;
            if (versionId == null && (versionName = operationValue.asObjectWithProperty("name", this.getFieldName(), errors)) != null) {
                Version version = this.versionManager.getVersion(issueCtx.getProjectObject().getId(), versionName);
                if (version != null) {
                    versionId = version.getId().toString();
                } else {
                    errors.addError(fieldId, "Version name '" + versionName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
            if (versionId == null) {
                return null;
            }
        }
        if (!(newList = new ArrayList<String>(currentFieldValue)).contains(versionId)) {
            newList.add(versionId);
        }
        return newList;
    }
}

