/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.AbstractFieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntityImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeImpl;
import com.atlassian.jira.issue.fields.layout.field.enterprise.ImmutableFieldConfigurationScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultFieldLayoutManager
extends AbstractFieldLayoutManager
implements FieldLayoutManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultFieldLayoutManager.class);
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final ConcurrentMap<Long, CacheObject<Long>> fieldSchemeCache = new ConcurrentHashMap<Long, CacheObject<Long>>();
    private final ConcurrentMap<Long, ImmutableFieldConfigurationScheme> fieldConfigurationSchemeCache = new ConcurrentHashMap<Long, ImmutableFieldConfigurationScheme>();
    private static final String FIELD_LAYOUT_SCHEME_ASSOCIATION = "FieldLayoutScheme";
    private ProjectManager projectManager;
    private final EventPublisher eventPublisher;
    private final AssociationManager associationManager;

    public DefaultFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, SubTaskManager subTaskManager, ProjectManager projectManager, EventPublisher eventPublisher, I18nHelper.BeanFactory i18n, AssociationManager associationManager) {
        super(fieldManager, ofBizDelegator, i18n);
        this.projectManager = projectManager;
        this.eventPublisher = eventPublisher;
        this.constantsManager = (ConstantsManager)Assertions.notNull((String)"constantsManager", (Object)constantsManager);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
        this.associationManager = associationManager;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public FieldLayout getFieldLayout(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("GenericValue must be an issue. It is a(n) " + issue.getEntityName() + ".");
        }
        return this.getFieldLayout(JiraEntityUtils.getProject(issue), issue.getString("type"));
    }

    @Override
    public FieldLayout getFieldLayout(Project project, String issueTypeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null.");
        }
        FieldConfigurationScheme fieldConfigurationScheme = this.getFieldConfigurationScheme(project);
        if (fieldConfigurationScheme != null) {
            Long fieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(issueTypeId);
            return this.getRelevantFieldLayout(fieldLayoutId);
        }
        return this.getFieldLayout();
    }

    @Override
    public FieldLayout getFieldLayout(GenericValue project, String issueTypeId) {
        if (project == null) {
            throw new IllegalArgumentException("Generic Value cannot be null.");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("Generic Value must be a Project - '" + project.getEntityName() + "' is not.");
        }
        FieldConfigurationScheme fieldConfigurationScheme = this.getFieldConfigurationScheme(project);
        if (fieldConfigurationScheme != null) {
            Long fieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(issueTypeId);
            return this.getRelevantFieldLayout(fieldLayoutId);
        }
        return this.getFieldLayout();
    }

    private ImmutableFieldConfigurationScheme buildFieldConfigurationScheme(GenericValue fieldLayoutSchemeGV) {
        Assertions.notNull((String)"fieldLayoutSchemeGV", (Object)fieldLayoutSchemeGV);
        Collection<GenericValue> schemeEntities = this.getFieldLayoutSchemeEntityGVs(fieldLayoutSchemeGV.getLong("id"));
        return new ImmutableFieldConfigurationScheme(fieldLayoutSchemeGV, schemeEntities);
    }

    private Collection<GenericValue> getFieldLayoutSchemeEntityGVs(Long fieldLayoutSchemeId) {
        try {
            return this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutSchemeId);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    @Override
    public List<FieldLayoutScheme> getFieldLayoutSchemes() {
        LinkedList<FieldLayoutScheme> fieldLayoutSchemes = new LinkedList<FieldLayoutScheme>();
        List fieldLayoutSchemeGVs = this.ofBizDelegator.findAll(FIELD_LAYOUT_SCHEME_ASSOCIATION, Collections.singletonList("name ASC"));
        for (GenericValue fieldLayoutSchemeGV : fieldLayoutSchemeGVs) {
            fieldLayoutSchemes.add(this.buildFieldLayoutScheme(fieldLayoutSchemeGV));
        }
        return fieldLayoutSchemes;
    }

    @Override
    public Collection<GenericValue> getRelatedProjects(FieldLayout fieldLayout) {
        ArrayList<GenericValue> relatedProjects = new ArrayList<GenericValue>();
        for (FieldConfigurationScheme fieldConfigurationScheme : this.getFieldConfigurationSchemes(fieldLayout)) {
            relatedProjects.addAll(this.getProjects(fieldConfigurationScheme));
        }
        if (fieldLayout.isDefault()) {
            relatedProjects.addAll(this.getProjects((FieldConfigurationScheme)null));
        }
        return relatedProjects;
    }

    @Override
    public List<EditableFieldLayout> getEditableFieldLayouts() {
        LinkedList<EditableFieldLayout> fieldLayouts = new LinkedList<EditableFieldLayout>();
        fieldLayouts.add((EditableFieldLayout)this.getEditableDefaultFieldLayout());
        List fieldLayoutGVs = this.ofBizDelegator.findByField("FieldLayout", "type", null, "name");
        for (GenericValue editableFieldLayoutGV : fieldLayoutGVs) {
            FieldLayout fieldLayout = this.getRelevantFieldLayout(editableFieldLayoutGV.getLong("id"));
            fieldLayouts.add((EditableFieldLayout)new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems()));
        }
        return fieldLayouts;
    }

    @Override
    public EditableFieldLayout getEditableFieldLayout(Long id) {
        FieldLayout fieldLayout = this.getRelevantFieldLayout(id);
        return new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems());
    }

    @Override
    public void updateFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        if (!TextUtils.stringSet((String)fieldLayoutScheme.getName())) {
            throw new IllegalArgumentException("Name passed must not be null.");
        }
        try {
            this.clearCaches();
            fieldLayoutScheme.getGenericValue().store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public void deleteFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            this.associationManager.removeAssociationsFromSink(fieldLayoutScheme.getGenericValue());
            fieldLayoutScheme.getGenericValue().remove();
            this.refresh();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public void deleteFieldLayout(FieldLayout fieldLayout) {
        try {
            GenericValue genericValue = fieldLayout.getGenericValue();
            if (genericValue != null) {
                genericValue.removeRelated("ChildFieldLayoutItem");
                genericValue.remove();
            }
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeEntities(FieldLayoutScheme fieldLayoutScheme) {
        try {
            LinkedList<FieldLayoutSchemeEntity> fieldLayoutSchemeEntities = new LinkedList<FieldLayoutSchemeEntity>();
            List fieldLayoutSchemeEntityGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutScheme.getId());
            for (GenericValue fieldLayoutSchemeEntityGV : fieldLayoutSchemeEntityGVs) {
                FieldLayoutSchemeEntityImpl fieldLayoutSchemeEntity = new FieldLayoutSchemeEntityImpl(this, fieldLayoutSchemeEntityGV, ComponentAccessor.getConstantsManager());
                fieldLayoutSchemeEntity.setFieldLayoutScheme(fieldLayoutScheme);
                fieldLayoutSchemeEntities.add(fieldLayoutSchemeEntity);
            }
            return fieldLayoutSchemeEntities;
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    @Override
    public void createFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        try {
            String issueTypeId = fieldLayoutSchemeEntity.getIssueTypeId();
            GenericValue fieldLayoutSchemeEntityGV = EntityUtils.createValue("FieldLayoutSchemeEntity", EasyMap.build((Object)"scheme", (Object)fieldLayoutSchemeEntity.getFieldLayoutScheme().getId(), (Object)"issuetype", (Object)issueTypeId, (Object)"fieldlayout", (Object)fieldLayoutSchemeEntity.getFieldLayoutId()));
            fieldLayoutSchemeEntity.setGenericValue(fieldLayoutSchemeEntityGV);
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while persisting field layout scheme entity.", (Throwable)e);
        }
    }

    @Override
    public void updateFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        try {
            fieldLayoutSchemeEntity.getGenericValue().store();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while persisting field layout scheme entity.", (Throwable)e);
        }
    }

    @Override
    public void removeFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        try {
            fieldLayoutSchemeEntity.getGenericValue().remove();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while removing field layout scheme entity.", (Throwable)e);
        }
    }

    @Override
    public void removeFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            fieldLayoutScheme.getGenericValue().remove();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public Collection<FieldConfigurationScheme> getFieldConfigurationSchemes(FieldLayout fieldLayout) {
        Long id = fieldLayout.isDefault() ? null : fieldLayout.getId();
        HashSet<Long> fieldLayoutSchemeIds = new HashSet<Long>();
        List fieldLayoutSchemeEntitiyGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "fieldlayout", (Object)id);
        for (GenericValue fieldLayoutSchemeEntitiyGV : fieldLayoutSchemeEntitiyGVs) {
            fieldLayoutSchemeIds.add(fieldLayoutSchemeEntitiyGV.getLong("scheme"));
        }
        HashSet<FieldConfigurationScheme> fieldConfigurationSchemes = new HashSet<FieldConfigurationScheme>(fieldLayoutSchemeIds.size());
        for (Long schemeId : fieldLayoutSchemeIds) {
            fieldConfigurationSchemes.add(this.getFieldConfigurationScheme(schemeId));
        }
        return fieldConfigurationSchemes;
    }

    @Override
    public void restoreSchemeFieldLayout(GenericValue scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must not be null.");
        }
        this.restoreFieldLayout(scheme.getLong("id"));
    }

    @Override
    public Collection<GenericValue> getProjects(FieldConfigurationScheme fieldConfigurationScheme) {
        if (fieldConfigurationScheme == null) {
            return this.getProjectsWithDefaultFieldConfigurationScheme();
        }
        GenericValue fieldConfigurationSchemeGV = this.makeFieldLayoutSchemeGenericValue(fieldConfigurationScheme.getId());
        try {
            return this.associationManager.getSourceFromSink(fieldConfigurationSchemeGV, "Project", "ProjectScheme", false);
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    private Collection<GenericValue> getProjectsWithDefaultFieldConfigurationScheme() {
        ArrayList<GenericValue> projects = new ArrayList<GenericValue>();
        for (GenericValue project : this.projectManager.getProjects()) {
            if (this.getFieldConfigurationScheme(project) != null) continue;
            projects.add(project);
        }
        return projects;
    }

    @Override
    public Collection<GenericValue> getProjects(FieldLayoutScheme fieldLayoutScheme) {
        try {
            return this.associationManager.getSourceFromSink(fieldLayoutScheme.getGenericValue(), "Project", "ProjectScheme", false);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public FieldLayoutScheme createFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            GenericValue genericValue = EntityUtils.createValue(FIELD_LAYOUT_SCHEME_ASSOCIATION, MapBuilder.build((Object)"name", (Object)fieldLayoutScheme.getName(), (Object)"description", (Object)fieldLayoutScheme.getDescription()));
            fieldLayoutScheme.setGenericValue(genericValue);
            return fieldLayoutScheme;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private FieldLayoutScheme buildFieldLayoutScheme(GenericValue genericValue) {
        if (genericValue != null) {
            return new FieldLayoutSchemeImpl(this, genericValue);
        }
        return null;
    }

    @Override
    public FieldConfigurationScheme getFieldConfigurationScheme(Long schemeId) {
        ImmutableFieldConfigurationScheme fieldConfigurationScheme = (ImmutableFieldConfigurationScheme)this.fieldConfigurationSchemeCache.get(schemeId);
        if (fieldConfigurationScheme != null) {
            return fieldConfigurationScheme;
        }
        GenericValue fieldLayoutSchemeGV = this.ofBizDelegator.findByPrimaryKey(FIELD_LAYOUT_SCHEME_ASSOCIATION, MapBuilder.build((Object)"id", (Object)schemeId));
        if (fieldLayoutSchemeGV == null) {
            throw new DataAccessException("No FieldLayoutScheme found for id " + schemeId);
        }
        fieldConfigurationScheme = this.buildFieldConfigurationScheme(fieldLayoutSchemeGV);
        ImmutableFieldConfigurationScheme result = this.fieldConfigurationSchemeCache.putIfAbsent(schemeId, fieldConfigurationScheme);
        return result == null ? fieldConfigurationScheme : result;
    }

    @Override
    public FieldLayoutScheme getMutableFieldLayoutScheme(Long schemeId) {
        return this.buildFieldLayoutScheme(this.ofBizDelegator.findByPrimaryKey(FIELD_LAYOUT_SCHEME_ASSOCIATION, MapBuilder.build((Object)"id", (Object)schemeId)));
    }

    @Override
    public boolean fieldConfigurationSchemeExists(String schemeName) {
        return !this.ofBizDelegator.findByField(FIELD_LAYOUT_SCHEME_ASSOCIATION, "name", (Object)schemeName).isEmpty();
    }

    @Override
    public Set<FieldLayout> getUniqueFieldLayouts(Project project) {
        HashSet<FieldLayout> uniqueLayouts = new HashSet<FieldLayout>();
        FieldConfigurationScheme scheme = this.getFieldConfigurationScheme(project.getGenericValue());
        if (scheme != null) {
            for (Long layoutId : scheme.getAllFieldLayoutIds((Collection)this.constantsManager.getAllIssueTypeIds())) {
                FieldLayout fieldLayout = this.getFieldLayout(layoutId);
                if (fieldLayout == null) continue;
                uniqueLayouts.add(fieldLayout);
            }
        } else {
            uniqueLayouts.add(this.getFieldLayout());
        }
        return uniqueLayouts;
    }

    @Override
    public FieldConfigurationScheme getFieldConfigurationScheme(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        return this.getFieldConfigurationScheme(project.getGenericValue());
    }

    @Override
    public FieldConfigurationScheme getFieldConfigurationScheme(GenericValue project) {
        if (project == null) {
            log.error((Object)"Project passed must not be null.");
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        Long projectId = project.getLong("id");
        CacheObject cacheObject = (CacheObject)this.fieldSchemeCache.get(projectId);
        if (cacheObject != null) {
            if (cacheObject.getValue() != null) {
                return this.getFieldConfigurationScheme((Long)cacheObject.getValue());
            }
            return null;
        }
        try {
            GenericValue fieldLayoutSchemeGV = EntityUtil.getOnly(this.associationManager.getSinkFromSource(project, FIELD_LAYOUT_SCHEME_ASSOCIATION, "ProjectScheme", false));
            if (fieldLayoutSchemeGV != null) {
                ImmutableFieldConfigurationScheme scheme = this.buildFieldConfigurationScheme(fieldLayoutSchemeGV);
                this.fieldSchemeCache.putIfAbsent(projectId, new CacheObject<Long>(scheme.getId()));
                return scheme;
            }
            this.fieldSchemeCache.putIfAbsent(projectId, new CacheObject<Object>(null));
            return null;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving a field layout scheme.", (Throwable)e);
        }
    }

    @Override
    public void addSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        try {
            FieldConfigurationScheme oldScheme = this.getFieldConfigurationScheme(project);
            if (oldScheme != null) {
                this.removeSchemeAssociation(project, oldScheme.getId());
            }
            if (fieldLayoutSchemeId != null) {
                GenericValue gvFieldLayoutScheme = this.makeFieldLayoutSchemeGenericValue(fieldLayoutSchemeId);
                this.associationManager.createAssociation(project, gvFieldLayoutScheme, "ProjectScheme");
            }
            this.clearCaches();
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    private GenericValue makeFieldLayoutSchemeGenericValue(Long fieldLayoutSchemeId) {
        GenericValue gvFieldLayoutScheme = this.ofBizDelegator.makeValue(FIELD_LAYOUT_SCHEME_ASSOCIATION);
        gvFieldLayoutScheme.set("id", (Object)fieldLayoutSchemeId);
        return gvFieldLayoutScheme;
    }

    @Override
    public void removeSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        GenericValue gvFieldLayoutScheme = this.ofBizDelegator.makeValue(FIELD_LAYOUT_SCHEME_ASSOCIATION);
        gvFieldLayoutScheme.set("id", (Object)fieldLayoutSchemeId);
        try {
            this.associationManager.removeAssociation(project, gvFieldLayoutScheme, "ProjectScheme");
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
        this.clearCaches();
    }

    @Override
    public FieldLayout getFieldLayout(Long id) {
        return this.getRelevantFieldLayout(id);
    }

    @Override
    public void refresh() {
        this.clearCaches();
        super.refresh();
    }

    protected void clearCaches() {
        this.fieldSchemeCache.clear();
        this.fieldConfigurationSchemeCache.clear();
    }

    @Override
    public boolean isFieldLayoutSchemesVisiblyEquivalent(Long fieldConfigurationSchemeId1, Long fieldConfigurationSchemeId2) {
        if (fieldConfigurationSchemeId1 == null && fieldConfigurationSchemeId2 == null) {
            return true;
        }
        FieldConfigurationScheme scheme1 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId1);
        FieldConfigurationScheme scheme2 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId2);
        for (String issueType : this.getAllRelevantIssueTypeIds()) {
            if (this.isFieldLayoutsVisiblyEquivalent(scheme1.getFieldLayoutId(issueType), scheme2.getFieldLayoutId(issueType))) continue;
            return false;
        }
        return true;
    }

    private FieldConfigurationScheme getNotNullFieldConfigurationScheme(Long fieldConfigurationSchemeId) {
        if (fieldConfigurationSchemeId == null) {
            return new DefaultFieldConfigurationScheme();
        }
        return this.getFieldConfigurationScheme(fieldConfigurationSchemeId);
    }

    @Override
    public boolean isFieldLayoutsVisiblyEquivalent(Long fieldLayoutId1, Long fieldLayoutId2) {
        Map<String, Boolean> map1 = this.createFieldIdToVisibilityMap(fieldLayoutId1);
        Map<String, Boolean> map2 = this.createFieldIdToVisibilityMap(fieldLayoutId2);
        return ((Object)map1).equals(map2);
    }

    private Map<String, Boolean> createFieldIdToVisibilityMap(Long fieldLayoutId) {
        FieldLayout fieldLayout = this.getFieldLayout(fieldLayoutId);
        List list = fieldLayout.getFieldLayoutItems();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (FieldLayoutItem item : list) {
            map.put(item.getOrderableField().getId(), item.isHidden());
        }
        return map;
    }

    protected List<String> getAllRelevantIssueTypeIds() {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeIds();
        }
        return CollectionUtil.transform(this.constantsManager.getRegularIssueTypeObjects().iterator(), (Function)new Function<IssueType, String>(){

            public String get(IssueType input) {
                return input.getId();
            }
        });
    }

    private class DefaultFieldConfigurationScheme
    implements FieldConfigurationScheme {
        private DefaultFieldConfigurationScheme() {
        }

        public Long getId() {
            return null;
        }

        public String getName() {
            return "Default Field Configuration Scheme";
        }

        public String getDescription() {
            return "";
        }

        public Long getFieldLayoutId(String issueTypeId) {
            return null;
        }

        public Set<Long> getAllFieldLayoutIds(Collection<String> allIssueTypeIds) {
            return Collections.singleton(null);
        }
    }
}

