/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemImpl;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FieldConfigImpl
implements FieldConfig,
Comparable {
    private final Long id;
    private final String name;
    private final String description;
    private final List configItems;
    private final String fieldId;

    public FieldConfigImpl(Long id, String name, String description, List configItemTypes, String fieldId) {
        this.id = id;
        this.name = StringUtils.abbreviate((String)name, (int)254);
        this.description = description;
        this.fieldId = fieldId;
        configItemTypes = configItemTypes == null ? Collections.EMPTY_LIST : configItemTypes;
        ArrayList<FieldConfigItemImpl> configItems = new ArrayList<FieldConfigItemImpl>(configItemTypes.size());
        for (FieldConfigItemType type : configItemTypes) {
            configItems.add(new FieldConfigItemImpl(type, this));
        }
        this.configItems = Collections.unmodifiableList(configItems);
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CustomField getCustomField() {
        CustomField customField = ManagerFactory.getCustomFieldManager().getCustomFieldObject(this.fieldId);
        if (customField == null) {
            throw new DataAccessException("No custom field for " + this.fieldId + ". This should not happen. Data is likely to be corrupt.");
        }
        return customField;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public List getConfigItems() {
        return this.configItems;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldConfigImpl)) {
            return false;
        }
        FieldConfigImpl rhs = (FieldConfigImpl)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }

    public int compareTo(Object obj) {
        FieldConfigImpl o = (FieldConfigImpl)obj;
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append((Object)this.getId(), (Object)o.getId()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 175).append((Object)this.getName()).append((Object)this.getId()).toHashCode();
    }
}

