/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractTextSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.DescriptionRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.DescriptionSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class DescriptionSystemField
extends AbstractTextSystemField
implements HideableField,
RequirableField,
RestAwareField,
RestFieldOperations {
    private static final String DESCRIPTION_NAME_KEY = "issue.field.description";
    private static final LuceneFieldSorter SORTER = new TextFieldSorter("sort_description");
    private final RendererManager rendererManager;

    public DescriptionSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, DescriptionSearchHandlerFactory searchHandlerFactory) {
        super("description", DESCRIPTION_NAME_KEY, velocityManager, applicationProperties, authenticationContext, rendererManager, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        String description;
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        if (fieldScreenRenderLayoutItem.isRequired() && (!TextUtils.stringSet((String)(description = (String)fieldValuesHolder.get(this.getId()))) || description.trim().length() <= 0)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        return issue.getDescription();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String desc = (String)this.rendererManager.getRendererForType(rendererType).transformFromEdit(this.getValueFromParams(fieldValueHolder));
            if (TextUtils.stringSet((String)desc)) {
                issue.setDescription(desc);
            } else {
                issue.setDescription(null);
            }
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setDescription(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.description";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return SORTER;
    }

    @Override
    protected String getEditTemplateName() {
        return "description-edit.vm";
    }

    @Override
    protected String getColumnViewTemplateName() {
        return "description-columnview.vm";
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        String rendererType = null;
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (fieldLayout.isFieldHidden(this.getId())) {
                return "bulk.edit.unavailable.hidden";
            }
            if (rendererType == null) {
                rendererType = fieldLayout.getRendererTypeForField("description");
                continue;
            }
            if (rendererType.equals(fieldLayout.getRendererTypeForField("description"))) continue;
            return "bulk.edit.unavailable.different.renderers";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, IssueContext issue) {
        return new FieldTypeInfo(JiraDataTypes.getType((Field)this), false, false, null, fieldLayoutItem.isRequired(), !fieldLayoutItem.isHidden(), true, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"string", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new DescriptionRestFieldOperationsHandler();
    }

    public JsonData getJsonFromIssue(Issue issue) {
        return new JsonData((Object)this.getValueFromIssue(issue));
    }
}

