/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.ComponentsField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.ComponentsRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ComponentSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.ComponentStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class ComponentsSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
RequirableField,
ComponentsField,
RestAwareField,
RestFieldOperations {
    private static final Logger log = Logger.getLogger(ComponentsSystemField.class);
    private static final String COMPONENTS_NAME_KEY = "issue.field.components";
    private static final Long UNKNOWN_COMPONENTS_ID = -1L;
    private final ProjectComponentManager projectComponentManager;
    private final ComponentStatisticsMapper componentStatisticsMapper;
    private final ProjectManager projectManager;
    private final JiraBaseUrls jiraBaseUrls;

    public ComponentsSystemField(VelocityManager velocityManager, ProjectComponentManager projectComponentManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, ComponentStatisticsMapper componentStatisticsMapper, ComponentSearchHandlerFactory componentSearchHandlerFactory, ProjectManager projectManager, JiraBaseUrls jiraBaseUrls) {
        super("components", COMPONENTS_NAME_KEY, velocityManager, applicationProperties, authenticationContext, permissionManager, componentSearchHandlerFactory);
        this.projectComponentManager = projectComponentManager;
        this.componentStatisticsMapper = componentStatisticsMapper;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("currentComponents", operationContext.getFieldValuesHolder().get(this.getId()));
        velocityParams.put("components", this.projectComponentManager.convertToGenericValues(this.getComponents(issue.getProjectObject())));
        velocityParams.put("unknownComponentId", UNKNOWN_COMPONENTS_ID);
        if (fieldLayoutItem != null) {
            velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
        }
        return this.renderTemplate("components-edit.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull((String)"bulkEditBean", (Object)bulkEditBean);
        Assertions.notEmpty((String)"selectedIssues", (Collection)bulkEditBean.getSelectedIssues());
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
            DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
            Function<Object, String> componentNameResolver = new Function<Object, String>(){

                public String get(Object input) {
                    try {
                        return ComponentsSystemField.this.projectComponentManager.find((Long)input).getName();
                    }
                    catch (EntityNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            Function<Issue, Collection<Object>> issueValueResolver = new Function<Issue, Collection<Object>>(){

                public Collection<Object> get(Issue input) {
                    LinkedHashMap fieldValuesHolder = new LinkedHashMap();
                    ComponentsSystemField.this.populateFromIssue(fieldValuesHolder, input);
                    return (Collection)fieldValuesHolder.get(ComponentsSystemField.this.getId());
                }
            };
            Map distinctComponentValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, this, (Function)issueValueResolver, (Function)componentNameResolver);
            Issue issue = bulkEditBean.getFirstTargetIssueObject();
            Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
            velocityParams.put("valuesToMap", distinctComponentValues);
            velocityParams.put("bulkMoveHelper", bulkMoveHelper);
            velocityParams.put("components", this.projectComponentManager.convertToGenericValues(this.getComponents(issue.getProjectObject())));
            velocityParams.put("unknownComponentId", UNKNOWN_COMPONENTS_ID);
            if (fieldLayoutItem != null) {
                velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
            return this.renderTemplate("components-bulkmove.vm", velocityParams);
        }
        return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("components", issue.getComponents());
        velocityParams.put("projectManager", this.projectManager);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("components", value);
        velocityParams.put("projectManager", this.projectManager);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("components-view.vm", velocityParams);
    }

    private Collection<ProjectComponent> getComponents(Project project) {
        return this.getComponents(project.getId());
    }

    private Collection<ProjectComponent> getComponents(Long id) {
        return this.projectComponentManager.findAllForProject(id);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        Collection componentIds = (Collection)fieldValuesHolder.get(this.getId());
        Project project = issue.getProjectObject();
        if (componentIds != null && componentIds.size() > 1) {
            for (Object componentId : componentIds) {
                Long l = (Long)componentId;
                if (!UNKNOWN_COMPONENTS_ID.equals(l)) continue;
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.noneselectedwithother"), ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
        }
        if (this.validateForRequiredField(errorCollectionToAddTo, i18n, fieldScreenRenderLayoutItem, componentIds, project)) {
            this.validateComponentForProject(errorCollectionToAddTo, i18n, componentIds, project);
        }
    }

    private boolean validateForRequiredField(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, Collection componentIds, Project project) {
        Collection<ProjectComponent> components = this.getComponents(project);
        if (fieldScreenRenderLayoutItem.isRequired() && (componentIds == null || componentIds.isEmpty() || componentIds.contains(UNKNOWN_COMPONENTS_ID))) {
            if (components.isEmpty()) {
                errorCollectionToAddTo.addErrorMessage(i18n.getText("createissue.error.components.required", i18n.getText(this.getNameKey()), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            return false;
        }
        return true;
    }

    private void validateComponentForProject(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Collection componentIds, Project project) {
        if (componentIds != null) {
            StringBuilder sb = null;
            for (Object componentIdObj : componentIds) {
                Long componentId = this.getComponentIdAsLong(componentIdObj);
                if (componentId == -1L) {
                    return;
                }
                try {
                    ProjectComponent component = this.projectComponentManager.find(componentId);
                    if (component.getProjectId().equals(project.getId())) continue;
                    if (sb == null) {
                        sb = new StringBuilder(component.getName()).append("(").append(component.getId()).append(")");
                        continue;
                    }
                    sb.append(", ").append(component.getName()).append("(").append(component.getId()).append(")");
                }
                catch (EntityNotFoundException e) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.components.does.not.exist", (Object)componentId), ErrorCollection.Reason.VALIDATION_FAILED);
                    return;
                }
            }
            if (sb != null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.components.components.not.valid.for.project", sb.toString(), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    private Long getComponentIdAsLong(Object o) {
        Long l = o instanceof String ? new Long((String)o) : (Long)o;
        return l;
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            LinkedList<Long> componentIds = new LinkedList<Long>();
            for (String aValue : value) {
                componentIds.add(new Long(aValue));
            }
            return componentIds;
        }
        return Collections.EMPTY_LIST;
    }

    public Object getValueFromParams(Map params) {
        List<ProjectComponent> components = this.getComponentsFromParams(params);
        if (components == null) {
            return Collections.emptyList();
        }
        return this.projectComponentManager.convertToGenericValues(components);
    }

    public List<ProjectComponent> getComponentsFromParams(Map params) {
        List componentIds = (List)params.get(this.getId());
        if (componentIds == null) {
            return null;
        }
        if (componentIds.isEmpty() || componentIds.contains(UNKNOWN_COMPONENTS_ID)) {
            return Collections.emptyList();
        }
        try {
            return this.projectComponentManager.getComponents(componentIds);
        }
        catch (EntityNotFoundException e) {
            throw new FieldValidationException("Trying to retrieve non existant component");
        }
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), this.getComponentIds(issue, stringValue));
    }

    private List<Long> getComponentIds(Issue issue, String stringValue) throws FieldValidationException {
        HashSet<Long> components = new HashSet<Long>();
        Project project = issue.getProjectObject();
        if (TextUtils.stringSet((String)stringValue)) {
            String[] componentParams;
            for (String componentParam : componentParams = StringUtils.split((String)stringValue, (String)",")) {
                try {
                    components.add(Long.valueOf(componentParam));
                }
                catch (NumberFormatException e) {
                    ProjectComponent component = this.projectComponentManager.findByComponentName(project.getId(), componentParam);
                    if (component != null) {
                        components.add(component.getId());
                        continue;
                    }
                    throw new FieldValidationException("Invalid component name '" + componentParam + "'.");
                }
            }
        }
        return new ArrayList<Long>(components);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Collection currentComponents = (Collection)modifiedValue.getOldValue();
        Collection newComponents = (Collection)modifiedValue.getNewValue();
        if (currentComponents == null || currentComponents.isEmpty()) {
            if (newComponents != null) {
                issueChangeHolder.addChangeItems(this.updateIssueValue(issue, newComponents));
            }
        } else if (!this.compareIdSets(newComponents, currentComponents)) {
            issueChangeHolder.addChangeItems(this.updateIssueValue(issue, newComponents));
        }
    }

    protected boolean compareIdSets(Collection newComponentGVs, Collection currentComponentGVs) {
        if (newComponentGVs != null && currentComponentGVs != null) {
            Collection newComponentIds = CollectionUtils.collect((Collection)newComponentGVs, (Transformer)JiraEntityUtils.GV_TO_ID_TRANSFORMER);
            Collection currentComponentIds = CollectionUtils.collect((Collection)currentComponentGVs, (Transformer)JiraEntityUtils.GV_TO_ID_TRANSFORMER);
            return this.valuesEqual(new HashSet(newComponentIds), new HashSet(currentComponentIds));
        }
        return newComponentGVs == null && currentComponentGVs == null;
    }

    private List updateIssueValue(Issue issue, Object value) {
        try {
            return JiraEntityUtils.updateDependentEntitiesCheckId(issue.getGenericValue(), (Collection)value, "IssueComponent", "Component");
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error while saving components '" + value + "' for issue with id '" + issue.getLong("id") + "'."));
            return Collections.EMPTY_LIST;
        }
    }

    public void createValue(Issue issue, Object value) {
        this.updateIssueValue(issue, value);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), Collections.emptyList());
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        Collection components = issue.getComponents();
        if (components != null) {
            LinkedList<Long> componentIds = new LinkedList<Long>();
            for (GenericValue componentGV : components) {
                componentIds.add(componentGV.getLong("id"));
            }
            fieldValuesHolder.put(this.getId(), componentIds);
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public Object getDefaultValue(Issue issue) {
        return Collections.EMPTY_LIST;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            issue.setComponents((Collection)this.getValueFromParams(fieldValueHolder));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (this.projectMoved(originalIssue, targetIssue)) {
                if (originalIssue.getComponents().isEmpty()) {
                    if (!targetFieldLayoutItem.isRequired()) continue;
                    return new MessagedResult(true);
                }
                return new MessagedResult(true);
            }
            if (!originalIssue.getComponents().isEmpty() || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    private boolean projectMoved(Issue originalIssue, Issue targetIssue) {
        Long targetProjectId;
        Long originalProjectId = originalIssue.getProjectObject().getId();
        return !originalProjectId.equals(targetProjectId = targetIssue.getProjectObject().getId());
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        Collection currentComponentNames = this.getComponentNames(originalIssue.getComponents());
        Collection<ProjectComponent> possibleComponents = this.getComponents(targetIssue.getProjectObject());
        LinkedList<Long> componentIds = new LinkedList<Long>();
        for (ProjectComponent possibleComponent : possibleComponents) {
            if (!currentComponentNames.contains(possibleComponent.getName())) continue;
            componentIds.add(possibleComponent.getId());
        }
        fieldValuesHolder.put(this.getId(), componentIds);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setComponents((Collection)Collections.EMPTY_LIST);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        Collection components = issue.getComponents();
        return components != null && !components.isEmpty();
    }

    private Collection getComponentNames(Collection components) {
        HashSet<String> componentNames = new HashSet<String>();
        for (GenericValue componentGV : components) {
            componentNames.add(componentGV.getString("name"));
        }
        return componentNames;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        GenericValue project = bulkEditBean.getProject();
        if (!bulkEditBean.isMultipleProjects() && project != null) {
            if (this.getComponents(project.getLong("id")).isEmpty()) {
                return "bulk.edit.unavailable.nocomponents";
            }
            for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
                if (!fieldLayout.isFieldHidden(this.getId())) continue;
                return "bulk.edit.unavailable.hidden";
            }
            for (Issue issue : bulkEditBean.getSelectedIssues()) {
                if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
                return "bulk.edit.unavailable.permission";
            }
            return null;
        }
        return "bulk.edit.unavailable.multipleprojects";
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.components";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.componentStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("components", issue.getComponents());
        return this.renderTemplate("components-columnview.vm", velocityParams);
    }

    public Collection getComponents(Issue issue, Map fieldValuesHolder) {
        Collection valuesFromMap = (Collection)this.getValueFromParams(fieldValuesHolder);
        if (valuesFromMap == null || valuesFromMap.isEmpty()) {
            return issue.getComponents();
        }
        return valuesFromMap;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, IssueContext issue) {
        Collection<ProjectComponent> components = this.getComponents(issue.getProjectObject());
        return new FieldTypeInfo(JiraDataTypes.getType((Field)this), true, false, components, fieldLayoutItem.isRequired(), !fieldLayoutItem.isHidden(), true, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"component", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new ComponentsRestFieldOperationsHandler(this.projectComponentManager);
    }

    public JsonData getJsonFromIssue(Issue issue) {
        Collection components = issue.getComponentObjects();
        Collection beans = ComponentJsonBean.shortBeans((Collection)components, (JiraBaseUrls)this.jiraBaseUrls);
        return new JsonData((Object)beans);
    }
}

