/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.velocity.VelocityManager;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDurationSystemField
extends NavigableFieldImpl {
    public AbstractDurationSystemField(String id, String nameKey, String columnHeadingKey, String defaultSortOrder, Comparator comparator, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super(id, nameKey, columnHeadingKey, defaultSortOrder, velocityManager, applicationProperties, authenticationContext);
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        Long duration = this.getDuration(issue);
        if (duration != null) {
            String durationString = Boolean.TRUE.equals(displayParams.get("excel_view")) ? duration.toString() : ComponentManager.getInstance().getJiraDurationUtils().getFormattedDuration(duration);
            velocityParams.put("duration", durationString);
        }
        return this.renderTemplate("duration-columnview.vm", velocityParams);
    }

    protected abstract Long getDuration(Issue var1);

    @Override
    public String prettyPrintChangeHistory(String changeHistory) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            return ComponentManager.getInstance().getJiraDurationUtils().getFormattedDuration(new Long(changeHistory));
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            return ComponentManager.getInstance().getJiraDurationUtils().getFormattedDuration(new Long(changeHistory), i18nHelper.getLocale());
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }
}

