/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectConverterImpl
implements SelectConverter {
    private final OptionsManager optionsManager;

    public SelectConverterImpl(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
    }

    public String getString(Object value) {
        if (value == null) {
            return "-1";
        }
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public String getObject(String stringValue) {
        if ("".equals(stringValue) || "-1".equals(stringValue) || "-2".equals(stringValue)) {
            return null;
        }
        return stringValue;
    }

    public SearchContext getPossibleSearchContextFromValue(Object value, CustomField customField) {
        String stringValue = this.getString(value);
        HashSet projectIds = new HashSet();
        HashSet issueTypeIds = new HashSet();
        for (FieldConfigScheme configScheme : customField.getConfigurationSchemes()) {
            Set entries = configScheme.getConfigsByConfig().entrySet();
            for (Map.Entry entry : entries) {
                Set associatedIssueTypes;
                FieldConfig config = (FieldConfig)entry.getKey();
                Options options = this.optionsManager.getOptions(config);
                if (options.getOptionForValue(stringValue, null) == null) continue;
                if (configScheme.isGlobal()) {
                    return new SearchContextImpl();
                }
                List associatedProjects = configScheme.getAssociatedProjects();
                if (associatedProjects != null) {
                    projectIds.addAll(GenericValueUtils.transformToLongIdsList((Collection)associatedProjects));
                }
                if ((associatedIssueTypes = configScheme.getAssociatedIssueTypes()) == null) continue;
                issueTypeIds.addAll(GenericValueUtils.transformToStringIdsList((Collection)associatedIssueTypes));
            }
        }
        projectIds.remove(ALL_LONG);
        issueTypeIds.remove("-1");
        return new SearchContextImpl(null, new ArrayList(projectIds), new ArrayList(issueTypeIds));
    }
}

