/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.AbstractIssue;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelComparator;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.ofbiz.ImmutableGenericValue;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.ofbiz.core.entity.GenericValue;

public class DocumentIssueImpl
extends AbstractIssue {
    private final Document document;
    private final FieldManager fieldManager;
    private IssueFactory issueFactory;
    private ProjectFactory projectFactory;
    private final JqlLocalDateSupport jqlLocalDateSupport;
    private Map customFieldValues = new HashMap();

    public DocumentIssueImpl(Document document, ConstantsManager constantsManager, FieldManager fieldManager, IssueManager issueManager, IssueFactory issueFactory, AttachmentManager attachmentManager, ProjectFactory projectFactory, JqlLocalDateSupport jqlLocalDateSupport) {
        super(constantsManager, issueManager, attachmentManager);
        this.document = document;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
        this.projectFactory = projectFactory;
        this.jqlLocalDateSupport = jqlLocalDateSupport;
    }

    public Long getId() {
        return Long.valueOf(this.document.get("issue_id"));
    }

    public GenericValue getProject() {
        return (GenericValue)this.getSingleValueFromField("project");
    }

    public Project getProjectObject() {
        Project project = null;
        GenericValue projectGv = this.getProject();
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    private Object getSingleValueFromField(String fieldName) {
        LuceneFieldSorter sorter = this.fieldManager.getNavigableField(fieldName).getSorter();
        return sorter.getValueFromLuceneField(this.document.get(sorter.getDocumentConstant()));
    }

    private List getMultipleValuesFromField(String fieldName) {
        LuceneFieldSorter sorter = this.fieldManager.getNavigableField(fieldName).getSorter();
        String[] documentValues = this.document.getValues(sorter.getDocumentConstant());
        if (documentValues == null || documentValues.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < documentValues.length; ++i) {
            String documentValue = documentValues[i];
            Object value = sorter.getValueFromLuceneField(documentValue);
            if (value == null) continue;
            values.add(value);
        }
        Collections.sort(values, sorter.getComparator());
        return values;
    }

    private List getIssuesFromField(String fieldName) {
        LuceneFieldSorter sorter = this.fieldManager.getNavigableField(fieldName).getSorter();
        String[] documentValues = this.document.getValues(sorter.getDocumentConstant());
        if (documentValues == null || documentValues.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < documentValues.length; ++i) {
            String documentValue = documentValues[i];
            Object value = sorter.getValueFromLuceneField(documentValue);
            if (value == null) continue;
            values.add(value);
        }
        Collections.sort(values, sorter.getComparator());
        return this.convertGenericValuesToIssues(values);
    }

    @Override
    public IssueType getIssueTypeObject() {
        return (IssueType)this.getSingleValueFromField("issuetype");
    }

    public GenericValue getIssueType() {
        IssueType issueType = (IssueType)this.getSingleValueFromField("issuetype");
        return issueType != null ? issueType.getGenericValue() : null;
    }

    public String getSummary() {
        return this.document.get("summary");
    }

    public User getAssigneeUser() {
        return (User)this.getSingleValueFromField("assignee");
    }

    public User getAssignee() {
        return (User)this.getSingleValueFromField("assignee");
    }

    public String getAssigneeId() {
        String assigneeUserId = this.document.get("issue_assignee");
        if ("unassigned".equals(assigneeUserId)) {
            return null;
        }
        return assigneeUserId;
    }

    public Collection<GenericValue> getComponents() {
        return this.getMultipleValuesFromField("components");
    }

    public Collection<ProjectComponent> getComponentObjects() {
        Collection<GenericValue> gvs = this.getComponents();
        ComponentConverter converter = new ComponentConverter();
        Collection<MutableProjectComponent> mutables = converter.convertToComponents(gvs);
        return converter.convertToProjectComponents(mutables);
    }

    public Set<Label> getLabels() {
        List fields = this.getMultipleValuesFromField("labels");
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String field : fields) {
            labels.add(new Label(null, this.getId(), field));
        }
        Collections.sort(labels, LabelComparator.INSTANCE);
        return Collections.unmodifiableSet(new LinkedHashSet(labels));
    }

    public User getReporterUser() {
        return (User)this.getSingleValueFromField("reporter");
    }

    public User getReporter() {
        return (User)this.getSingleValueFromField("reporter");
    }

    public String getReporterId() {
        String reporterUserId = this.document.get("issue_author");
        if ("issue_no_reporter".equals(reporterUserId)) {
            return null;
        }
        return reporterUserId;
    }

    public String getDescription() {
        return this.document.get("description");
    }

    public String getEnvironment() {
        return this.document.get("environment");
    }

    public Collection<Version> getAffectedVersions() {
        return this.getMultipleValuesFromField("versions");
    }

    public Collection<Version> getFixVersions() {
        return this.getMultipleValuesFromField("fixVersions");
    }

    public Timestamp getDueDate() {
        LocalDate localDate = (LocalDate)this.getSingleValueFromField("duedate");
        if (localDate == null) {
            return null;
        }
        return new Timestamp(this.jqlLocalDateSupport.convertToDate(localDate).getTime());
    }

    private Timestamp getDateField(String fieldName) {
        Date date = (Date)this.getSingleValueFromField(fieldName);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public GenericValue getSecurityLevel() {
        return (GenericValue)this.getSingleValueFromField("security");
    }

    public Long getSecurityLevelId() {
        String securityLevelId = this.document.get("issue_security_level");
        return securityLevelId != null && !"-1".equals(securityLevelId) ? Long.valueOf(securityLevelId) : null;
    }

    @Override
    public Priority getPriorityObject() {
        return (Priority)this.getSingleValueFromField("priority");
    }

    public GenericValue getPriority() {
        Priority priority = (Priority)this.getSingleValueFromField("priority");
        return priority != null ? priority.getGenericValue() : null;
    }

    public String getResolutionId() {
        Resolution resolution = this.getResolutionObject();
        if (resolution == null) {
            return null;
        }
        return resolution.getId();
    }

    @Override
    public Resolution getResolutionObject() {
        return (Resolution)this.getSingleValueFromField("resolution");
    }

    public GenericValue getResolution() {
        Resolution resolution = (Resolution)this.getSingleValueFromField("resolution");
        return resolution != null ? resolution.getGenericValue() : null;
    }

    public String getKey() {
        return (String)this.getSingleValueFromField("issuekey");
    }

    public Long getVotes() {
        return (Long)this.getSingleValueFromField("votes");
    }

    public Long getWatches() {
        return (Long)this.getSingleValueFromField("watches");
    }

    public Timestamp getCreated() {
        return this.getDateField("created");
    }

    public Timestamp getResolutionDate() {
        return this.getDateField("resolutiondate");
    }

    public Timestamp getUpdated() {
        return this.getDateField("updated");
    }

    public Long getWorkflowId() {
        throw new UnsupportedOperationException("We don't currently index workflowid - can't get it from document");
    }

    public Object getCustomFieldValue(CustomField customField) {
        if (!this.customFieldValues.containsKey(customField)) {
            this.customFieldValues.put(customField, customField.getValue((Issue)this));
        }
        return this.customFieldValues.get(customField);
    }

    @Override
    public Status getStatusObject() {
        return (Status)this.getSingleValueFromField("status");
    }

    public GenericValue getStatus() {
        Status status = (Status)this.getSingleValueFromField("status");
        return status != null ? status.getGenericValue() : null;
    }

    public Long getOriginalEstimate() {
        return (Long)this.getSingleValueFromField("timeoriginalestimate");
    }

    public Long getEstimate() {
        return (Long)this.getSingleValueFromField("timeestimate");
    }

    public Long getTimeSpent() {
        return (Long)this.getSingleValueFromField("timespent");
    }

    public Object getExternalFieldValue(String fieldId) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isSubTask() {
        return this.getParentId() != null;
    }

    public Long getParentId() {
        String parentTaskId = this.document.get("issue_parenttask");
        return parentTaskId != null ? Long.decode(parentTaskId) : null;
    }

    public boolean isCreated() {
        return true;
    }

    public Collection getSubTasks() {
        return this.getMultipleValuesFromField("subtasks");
    }

    public Collection getSubTaskObjects() {
        return this.getIssuesFromField("subtasks");
    }

    public IssueRenderContext getIssueRenderContext() {
        return new IssueRenderContext((Issue)this);
    }

    public String getString(String name) {
        throw new UnsupportedOperationException("This code or velocity template expects a GenericValue, but received an Issue.  We need to recode");
    }

    public Timestamp getTimestamp(String name) {
        throw new UnsupportedOperationException("This code or velocity template expects a GenericValue, but received an Issue.  We need to recode");
    }

    public Long getLong(String name) {
        throw new UnsupportedOperationException("This code or velocity template expects a GenericValue, but received an Issue.  We need to recode");
    }

    public GenericValue getGenericValue() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("id", this.getId());
        values.put("project", this.getProject().getLong("id"));
        values.put("key", this.getKey());
        values.put("type", this.getIdFromGV(this.getIssueType()));
        values.put("status", this.getIdFromGV(this.getStatus()));
        values.put("priority", this.getIdFromGV(this.getPriority()));
        values.put("resolution", this.getIdFromGV(this.getResolution()));
        values.put("reporter", this.getReporterId());
        values.put("assignee", this.getAssigneeId());
        values.put("summary", this.getSummary());
        values.put("description", this.getDescription());
        values.put("environment", this.getEnvironment());
        values.put("created", this.getCreated());
        values.put("updated", this.getUpdated());
        values.put("duedate", this.getDueDate());
        values.put("votes", this.getVotes());
        values.put("timeoriginalestimate", this.getOriginalEstimate());
        values.put("timeestimate", this.getEstimate());
        values.put("timespent", this.getTimeSpent());
        values.put("security", this.getSecurityLevelId());
        return new ImmutableGenericValue(CoreFactory.getGenericDelegator(), "Issue", values);
    }

    private String getIdFromGV(GenericValue targetGV) {
        return targetGV != null ? targetGV.getString("id") : null;
    }

    public void store() {
        throw new UnsupportedOperationException("Cannot store a DocumentIssueImpl");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue issue = (Issue)o;
        return !(this.getKey() != null ? !this.getKey().equals(issue.getKey()) : issue.getKey() != null);
    }

    public int hashCode() {
        return this.getKey() != null ? this.getKey().hashCode() : 0;
    }

    private List convertGenericValuesToIssues(List genericValues) {
        ArrayList<MutableIssue> issueObjects = new ArrayList<MutableIssue>();
        for (GenericValue issueGV : genericValues) {
            issueObjects.add(this.issueFactory.getIssue(issueGV));
        }
        return issueObjects;
    }
}

