/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.DelegateSearcher;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.CompositeCloseable;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;

class DelayCloseSearcher
extends DelegateSearcher
implements DelayCloseable {
    private final DelayCloseable.Helper helper;

    DelayCloseSearcher(@NotNull IndexSearcher searcher) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new SearcherCloser(searcher));
    }

    DelayCloseSearcher(@NotNull IndexSearcher searcher, @NotNull Closeable closeAction) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new CompositeCloseable(closeAction, new SearcherCloser(searcher)));
    }

    @Override
    public void closeWhenDone() {
        this.helper.closeWhenDone();
    }

    @Override
    public boolean isClosed() {
        return this.helper.isClosed();
    }

    @Override
    public void open() {
        this.helper.open();
    }

    @Override
    public void close() {
        this.helper.close();
    }

    private static class SearcherCloser
    implements Closeable {
        private final IndexSearcher searcher;

        SearcherCloser(IndexSearcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public void close() {
            try {
                this.searcher.close();
                this.searcher.getIndexReader().decRef();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

