/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.util;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.Collection;

public class IssueTypeImportHelper {
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public IssueTypeImportHelper(ConstantsManager constantsManager, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager) {
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    public IssueType getIssueTypeForName(String name) {
        if (name == null) {
            return null;
        }
        for (IssueType issueType : this.constantsManager.getAllIssueTypeObjects()) {
            if (!name.equals(issueType.getName())) continue;
            return issueType;
        }
        return null;
    }

    public boolean isMappingValid(IssueType newIssueType, String projectKey, boolean oldIssueTypeIsSubTask) {
        return this.isIssueTypeValidForProject(projectKey, newIssueType.getId()) && newIssueType.isSubTask() == oldIssueTypeIsSubTask;
    }

    public boolean isIssueTypeValidForProject(String projectKey, String newIssueTypeId) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Collection issueTypesForProject = project == null ? this.issueTypeSchemeManager.getIssueTypesForDefaultScheme() : this.issueTypeSchemeManager.getIssueTypesForProject(project);
        IssueType existingIssueType = this.getExistingIssueTypeForId(issueTypesForProject, newIssueTypeId);
        return existingIssueType != null;
    }

    private IssueType getExistingIssueTypeForId(Collection issueTypesForProject, String newId) {
        IssueType existingIssueType = null;
        for (IssueType issueType : issueTypesForProject) {
            if (!newId.equals(issueType.getId())) continue;
            existingIssueType = issueType;
            break;
        }
        return existingIssueType;
    }
}

