/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalTrackback;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.TrackbackParser;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TrackbackParserImpl
implements TrackbackParser {
    private static final String ID = "id";
    private static final String ISSUE = "issue";
    private static final String URL = "url";
    private static final String TITLE = "title";
    private static final String CREATED = "created";
    private static final String EXCERPT = "excerpt";
    private static final String BLOGNAME = "blogname";

    @Override
    public ExternalTrackback parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = (String)attributes.get(ID);
        String issueId = (String)attributes.get(ISSUE);
        String url = (String)attributes.get(URL);
        String excerpt = (String)attributes.get(EXCERPT);
        String title = (String)attributes.get(TITLE);
        String blogName = (String)attributes.get(BLOGNAME);
        String created = (String)attributes.get(CREATED);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("A file attachment must have an id specified.");
        }
        if (StringUtils.isEmpty((String)issueId)) {
            throw new ParseException("A file attachment with id '" + id + "' must have an issue id specified.");
        }
        if (StringUtils.isEmpty((String)created)) {
            throw new ParseException("A file attachment with id '" + id + "' must have a create date specified.");
        }
        Timestamp createdDate = Timestamp.valueOf(created);
        return new ExternalTrackback(id, issueId, url, blogName, excerpt, title, createdDate);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalTrackback trackback) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, trackback.getId());
        attributes.put(ISSUE, trackback.getIssueId());
        attributes.put(URL, trackback.getUrl());
        attributes.put(EXCERPT, trackback.getExcerpt());
        attributes.put(TITLE, trackback.getTitle());
        attributes.put(BLOGNAME, trackback.getBlogName());
        if (trackback.getCreated() != null) {
            attributes.put(CREATED, new Timestamp(trackback.getCreated().getTime()).toString());
        }
        return new EntityRepresentationImpl("TrackbackPing", attributes);
    }
}

