/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.imports.project.parser.OSPropertyParser;
import com.atlassian.jira.imports.project.parser.ProjectParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.HashMap;
import java.util.Map;

public class ProjectParserImpl
extends OSPropertyParser
implements ProjectParser {
    private final Map osPropertyIdMap = new HashMap();
    private final Map emailSenderMap = new HashMap();

    @Override
    public ExternalProject parseProject(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes cannot be null");
        }
        String id = (String)attributes.get("id");
        String name = (String)attributes.get("name");
        String lead = (String)attributes.get("lead");
        String description = (String)attributes.get("description");
        String key = (String)attributes.get("key");
        String url = (String)attributes.get("url");
        String assigneeType = (String)attributes.get("assigneetype");
        String counter = (String)attributes.get("counter");
        if (id == null) {
            throw new ParseException("No id field for Project.");
        }
        if (key == null) {
            throw new ParseException("No key field for Project.");
        }
        ExternalProject project = new ExternalProject();
        project.setId(id);
        project.setName(name);
        project.setLead(lead);
        project.setDescription(description);
        project.setKey(key);
        project.setUrl(url);
        project.setAssigneeType(assigneeType);
        project.setCounter(counter);
        project.setEmailSender((String)this.emailSenderMap.get(id));
        return project;
    }

    @Override
    public void parseOther(String elementName, Map attributes) {
        String projectID;
        Null.not("elementName", elementName);
        if (elementName.equals("OSPropertyEntry") && "Project".equals(this.getEntityName(attributes)) && "jira.project.email.sender".equals(this.getPropertyKey(attributes))) {
            this.osPropertyIdMap.put(attributes.get("id"), attributes.get("entityId"));
        }
        if (elementName.equals("OSPropertyString") && (projectID = (String)this.osPropertyIdMap.get(attributes.get("id"))) != null) {
            this.emailSenderMap.put(projectID, attributes.get("value"));
        }
    }
}

