/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.reindex;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelper;
import com.atlassian.jira.web.action.admin.plugins.PluginReindexHelperImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;

public class ReindexMessageListener
implements Startable {
    private final PluginReindexHelper pluginReindexHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final ReindexMessageManager reindexMessageManager;
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;

    public ReindexMessageListener(JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor, ReindexMessageManager reindexMessageManager, EventPublisher eventPublisher) {
        this.pluginAccessor = pluginAccessor;
        this.reindexMessageManager = reindexMessageManager;
        this.eventPublisher = eventPublisher;
        this.pluginReindexHelper = new PluginReindexHelperImpl(this.pluginAccessor);
        this.authenticationContext = authenticationContext;
    }

    @EventListener
    public synchronized void pluginModuleEnabled(PluginModuleEnabledEvent pmEnabledEvent) {
        if (this.pluginReindexHelper.doesEnablingPluginModuleRequireMessage(pmEnabledEvent.getModule().getCompleteKey())) {
            this.reindexMessageManager.pushMessage(this.authenticationContext.getLoggedInUser(), "admin.notifications.task.plugins");
        }
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

