/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import com.atlassian.jira.mail.IssueMailQueueItem;
import com.atlassian.jira.mail.IssueMailQueueItemFactory;
import com.atlassian.jira.mail.UserMailQueueItem;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.queue.MailQueueItem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MailListener
extends AbstractIssueEventListener
implements IssueEventListener,
UserEventListener {
    private static final Logger log = Logger.getLogger(MailListener.class);
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueMailQueueItemFactory issueMailQueueItemFactory;
    private final UserManager userManager;

    public MailListener(NotificationSchemeManager notificationSchemeManager, IssueMailQueueItemFactory issueMailQueueItemFactory, UserManager userManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueMailQueueItemFactory = issueMailQueueItemFactory;
        this.userManager = userManager;
    }

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    protected void sendNotification(IssueEvent event) {
        GenericValue projectGV;
        GenericValue notificationScheme;
        if (event.isSendMail() && (notificationScheme = this.notificationSchemeManager.getNotificationSchemeForProject(projectGV = event.getIssue().getProject())) != null) {
            this.createMailItems(notificationScheme, event);
        }
    }

    protected void createMailItems(GenericValue notificationScheme, IssueEvent event) {
        try {
            List notificationSchemeEntities = this.notificationSchemeManager.getEntities(notificationScheme, event.getEventTypeId());
            HashSet<NotificationRecipient> allRecipients = new HashSet<NotificationRecipient>();
            for (GenericValue schemeEntity : notificationSchemeEntities) {
                SchemeEntity notificationSchemeEntity = new SchemeEntity(schemeEntity.getLong("id"), schemeEntity.getString("type"), schemeEntity.getString("parameter"), schemeEntity.get("eventTypeId"), schemeEntity.get("templateId"), schemeEntity.getLong("scheme"));
                Long templateId = ComponentManager.getInstance().getTemplateManager().getTemplate(notificationSchemeEntity).getId();
                Set intendedRecipients = this.notificationSchemeManager.getRecipients(event, notificationSchemeEntity);
                HashSet<NotificationRecipient> actualRecipients = new HashSet<NotificationRecipient>();
                if (intendedRecipients == null || intendedRecipients.isEmpty()) continue;
                for (NotificationRecipient notificationRecipient : intendedRecipients) {
                    if (!allRecipients.contains(notificationRecipient)) {
                        actualRecipients.add(notificationRecipient);
                        allRecipients.add(notificationRecipient);
                        continue;
                    }
                    log.debug((Object)("Multiple event (" + event.getEventTypeId() + ") notification emails intended for the recipient: " + notificationRecipient.getUserRecipient() + ". Sending first intended email only for the event."));
                }
                if (actualRecipients.isEmpty()) continue;
                IssueMailQueueItem item = this.issueMailQueueItemFactory.getIssueMailQueueItem(event, templateId, actualRecipients, notificationSchemeEntity.getType());
                ManagerFactory.getMailQueue().addItem((MailQueueItem)item);
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("There was an error accessing the notifications for the scheme: " + notificationScheme.getString("name") + "."), (Throwable)e);
        }
    }

    public void issueCreated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueAssigned(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueClosed(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueResolved(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueReopened(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueUpdated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueCommented(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorkLogged(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueDeleted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueMoved(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueStarted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueStopped(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueGenericEvent(IssueEvent event) {
        this.sendNotification(event);
    }

    public void customEvent(IssueEvent event) {
        this.sendNotification(event);
    }

    protected void sendUserMail(UserEvent event, String subject, String subjectKey, String template) {
        UserMailQueueItem item = new UserMailQueueItem(event, subject, subjectKey, template);
        ManagerFactory.getMailQueue().addItem((MailQueueItem)item);
    }

    public void userSignup(UserEvent event) {
        this.sendUserMail(event, "Account signup", "template.user.signup.subject", "usersignup.vm");
    }

    public void userCreated(UserEvent event) {
        if (this.userManager.canUpdateUserPassword(event.getUser())) {
            this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated.vm");
        } else {
            this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated-nopassword.vm");
        }
    }

    public void userForgotPassword(UserEvent event) {
        this.sendUserMail(event, "Account password", "template.user.forgotpassword.subject", "forgotpassword.vm");
    }

    public void userForgotUsername(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.forgotusername.subject", "forgotusernames.vm");
    }

    public void userCannotChangePassword(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.cannotchangepassword.subject", "cannotchangepassword.vm");
    }

    public boolean isInternal() {
        return true;
    }

    public boolean isUnique() {
        return true;
    }

    public String getDescription() {
        return "For each user or issue event, generate an appropriate email, and send to the required participants.";
    }
}

