/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.AbstractDatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class PostgresDatabaseConfig
extends AbstractDatabaseConfig {
    @Override
    public String getDatabaseType() {
        return "PostgreSQL";
    }

    @Override
    public String getInstanceFieldName() {
        return "Database";
    }

    @Override
    public String getClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getUrl(String hostname, String port, String instance) throws ValidationException {
        if (instance == null || instance.length() == 0) {
            throw new ValidationException("Database is a required field");
        }
        String host = hostname.trim();
        port = (port = port.trim()).length() == 0 ? "" : ":" + port;
        if (host.length() == 0) {
            if (port.length() == 0) {
                return "jdbc:postgresql:" + instance.trim();
            }
            host = "localhost";
        }
        return "jdbc:postgresql://" + host + port + "/" + instance.trim();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        DatabaseInstance databaseInstance = new DatabaseInstance();
        String stripped = this.removeProtocolPrefix(jdbcUrl);
        if (!stripped.startsWith("//")) {
            databaseInstance.setInstance(stripped);
            return databaseInstance;
        }
        String[] hostPort_Database = (stripped = stripped.substring(2)).split("/", 2);
        if (hostPort_Database.length != 2) {
            throw new ParseException("Unable to parse the JDBC URL '" + jdbcUrl + "'. Missing '/' separator.");
        }
        databaseInstance.setInstance(hostPort_Database[1]);
        String[] hostPort = hostPort_Database[0].split(":");
        databaseInstance.setHostname(hostPort[0]);
        if (hostPort.length > 1) {
            databaseInstance.setPort(hostPort[1]);
        }
        return databaseInstance;
    }

    @Override
    protected String getProtocolPrefix() {
        return "jdbc:postgresql:";
    }
}

