/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.Configurator;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.configurator.db.DatabaseConfigConsoleImpl;
import com.atlassian.jira.configurator.db.MySqlDatabaseConfig;
import com.atlassian.jira.configurator.db.OracleDatabaseConfig;
import com.atlassian.jira.configurator.db.PostgresDatabaseConfig;
import com.atlassian.jira.configurator.db.SqlServerDatabaseConfig;
import com.atlassian.jira.exception.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;

public class ConfiguratorConsole {
    private BufferedReader in;
    private PrintStream out;
    private final DatabaseConfigConsole MYSQL_CONFIG = new DatabaseConfigConsoleImpl(new MySqlDatabaseConfig());
    private final DatabaseConfigConsole ORACLE_CONFIG = new DatabaseConfigConsoleImpl(new OracleDatabaseConfig());
    private final DatabaseConfigConsole POSTGRES_CONFIG = new DatabaseConfigConsoleImpl(new PostgresDatabaseConfig());
    private final DatabaseConfigConsole SQL_SERVER_CONFIG = new DatabaseConfigConsoleImpl(new SqlServerDatabaseConfig());
    private DatabaseType selectedDatabaseType;
    private String jiraHome;
    private String connectionPoolSize;

    public void setSettings(Settings settings) {
        this.jiraHome = settings.getJiraHome();
        this.connectionPoolSize = settings.getDbPoolSize();
        this.selectedDatabaseType = settings.getDatabaseType();
        try {
            this.getSelectedDatabaseConfig().setSettings(settings);
        }
        catch (ParseException e) {
            this.out.println("Unable to fully parse the current JDBC settings. Some settings may be blank.");
            this.out.println("Parse Exception: " + e.getMessage());
        }
    }

    public void start() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.out = System.out;
        this.showWelcomeMessage();
        try {
            this.showMainMenu();
        }
        catch (IOException e) {
            this.out.println();
            this.out.println("A fatal IOException has occurred: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void showMainMenu() throws IOException {
        block5: while (true) {
            this.out.println();
            this.out.println("--- Main Menu ---");
            this.out.println("[H] Configure JIRA Home");
            this.out.println("[D] Configure Database connection");
            this.out.println("[S] Save and Exit");
            this.out.println("[X] Exit without Saving");
            char ch = this.firstCharUpper();
            switch (ch) {
                case 'D': {
                    this.showDatabaseSettings();
                    continue block5;
                }
                case 'X': {
                    System.exit(0);
                }
                case 'S': {
                    this.saveSettings();
                }
            }
            this.out.println("Unknown command '" + ch + "'");
        }
    }

    private void saveSettings() {
        try {
            Configurator.saveSettings(this.gatherNewSettings());
            this.out.println("Settings saved successfully.");
            System.exit(0);
        }
        catch (ValidationException ex) {
            this.printErrorMessage(ex);
        }
        catch (IOException ex) {
            this.printErrorMessage(ex);
        }
    }

    private Settings gatherNewSettings() throws ValidationException {
        Settings newSettings = new Settings();
        newSettings.setJiraHome(this.jiraHome);
        this.setPoolSize(newSettings);
        this.getSelectedDatabaseConfig().saveSettings(newSettings);
        return newSettings;
    }

    private void setPoolSize(Settings newSettings) throws ValidationException {
        String newPoolSize = this.connectionPoolSize.trim();
        if (newPoolSize.length() == 0) {
            newSettings.setDbPoolSize("20");
            return;
        }
        int poolSize = 0;
        try {
            poolSize = Integer.parseInt(newPoolSize);
            newSettings.setDbPoolSize(newPoolSize);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Connection Pool size must be a valid integer.");
        }
        if (poolSize < 1) {
            throw new ValidationException("Connection Pool size must be greater than zero.");
        }
    }

    private void showWelcomeMessage() {
        this.out.println("----------------------");
        this.out.println("JIRA Configurator v1.0");
        this.out.println("----------------------");
    }

    private void showDatabaseSettings() throws IOException {
        while (true) {
            this.out.println("Database Type : " + this.selectedDatabaseType.getDisplayName());
            this.out.println("Instance      : " + this.getSelectedDatabaseConfig().getInstanceName());
            this.out.println("Connect As    : " + this.getSelectedDatabaseConfig().getUsername() + " / " + this.getSelectedDatabaseConfig().getPassword());
            this.out.println("Select:");
            char defaultCommand = this.selectedDatabaseType.getDisplayName().charAt(0);
            this.showMenuItem('H', "HSQL (not for production use)", defaultCommand);
            this.showMenuItem('M', "MySQL", defaultCommand);
            this.showMenuItem('O', "Oracle", defaultCommand);
            this.showMenuItem('P', "PostgreSQL", defaultCommand);
            this.showMenuItem('S', "SQL Server (MS-SQL)", defaultCommand);
            this.showMenuItem('X', "Return to Main Menu", defaultCommand);
            char ch = Character.toUpperCase(this.readFirstChar());
            switch (ch) {
                case '\n': 
                case '\r': {
                    this.doDatabaseConfig();
                    return;
                }
                case 'M': {
                    this.selectedDatabaseType = DatabaseType.MY_SQL;
                    this.doDatabaseConfig();
                    return;
                }
                case 'O': {
                    this.selectedDatabaseType = DatabaseType.ORACLE;
                    this.doDatabaseConfig();
                    return;
                }
                case 'X': {
                    return;
                }
            }
            this.out.println("Unknown command '" + ch + "'");
        }
    }

    private void doDatabaseConfig() throws IOException {
        DatabaseConfigConsole databaseConfig = this.getSelectedDatabaseConfig();
        while (true) {
            this.out.println(databaseConfig.getDatabaseType() + " Database Configuration.");
            for (ConfigField configField : databaseConfig.getFields()) {
                this.out.print(configField.getLabel() + ' ' + '(' + configField.getValue() + "): ");
                String newValue = this.readLine();
                if (newValue.length() <= 0) continue;
                configField.setValue(newValue.trim());
            }
            this.out.println("Test Connection? (Y)");
            if (!this.readYesNoWithDefault(true)) break;
            this.out.println("Attempting to connect to " + this.getSelectedDatabaseConfig().getInstanceName());
            String error = this.testConnection(databaseConfig);
            if (error == null) {
                this.out.println("Connection successful!");
                return;
            }
            this.out.println("Connection failed: " + error);
            this.out.println();
        }
    }

    private String testConnection(DatabaseConfigConsole databaseConfig) {
        String errorMessage;
        try {
            databaseConfig.testConnection();
            return null;
        }
        catch (UnsupportedClassVersionError ex) {
            errorMessage = "UnsupportedClassVersionError occurred. It is likely your JDBC drivers use a newer version of Java than you are running now.";
        }
        catch (ClassNotFoundException ex) {
            errorMessage = "Driver class '" + databaseConfig.getClassName() + "' not found. Ensure the DB driver is installed in the 'lib' directory.";
        }
        catch (SQLException ex) {
            String message = ex.getMessage();
            if (message.contains("Stack Trace")) {
                if (message.contains("UnknownHostException")) {
                    message = "Unknown host.";
                } else if (message.contains("Check that the hostname and port are correct")) {
                    message = "Check that the hostname and port are correct.";
                }
            }
            errorMessage = "Could not connect to the DB: " + message;
        }
        catch (RuntimeException ex) {
            errorMessage = "An unexpected error occurred: " + ex.getMessage();
            System.err.println(errorMessage);
            ex.printStackTrace(System.err);
        }
        catch (ValidationException e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private void showMenuItem(char key, String label, char defaultCommandKey) {
        if (key == defaultCommandKey) {
            this.out.print("*");
        } else {
            this.out.print(" ");
        }
        this.out.println(" [" + key + "] " + label);
    }

    private char firstCharUpper() throws IOException {
        return Character.toUpperCase(this.readFirstChar());
    }

    private char readFirstChar() throws IOException {
        char firstChar = (char)this.in.read();
        while (this.in.ready()) {
            this.in.read();
        }
        return firstChar;
    }

    private String readLine() throws IOException {
        return this.in.readLine();
    }

    private boolean readYesNoWithDefault(boolean defaultValue) throws IOException {
        String response = this.readLine();
        if (response.length() == 0) {
            return defaultValue;
        }
        char ch = Character.toUpperCase(response.charAt(0));
        switch (ch) {
            case 'Y': 
            case 'y': {
                return true;
            }
            case 'N': 
            case 'n': {
                return false;
            }
        }
        return defaultValue;
    }

    private void printErrorMessage(Exception ex) {
        this.out.println(ex.getMessage());
    }

    private DatabaseConfigConsole getSelectedDatabaseConfig() {
        switch (this.selectedDatabaseType) {
            case ORACLE: {
                return this.ORACLE_CONFIG;
            }
            case MY_SQL: {
                return this.MYSQL_CONFIG;
            }
            case POSTGRES: {
                return this.POSTGRES_CONFIG;
            }
            case SQL_SERVER: {
                return this.SQL_SERVER_CONFIG;
            }
        }
        throw new IllegalStateException("Unknown database type " + (Object)((Object)this.selectedDatabaseType));
    }
}

