/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;

public class DefaultReindexMessageManager
implements ReindexMessageManager,
Startable {
    static final String PS_KEY = "admin.message.manager";
    static final String PS_KEY_USER = "user";
    static final String PS_KEY_TASK = "task";
    static final String PS_KEY_TIME = "time";
    private final UserFormatManager userFormatManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final OutlookDateManager outlookDateManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<PropertySet> propertiesReference;

    public DefaultReindexMessageManager(final JiraPropertySetFactory jiraPropertySetFactory, UserFormatManager userFormatManager, I18nHelper.BeanFactory i18nFactory, OutlookDateManager outlookDateManager, VelocityRequestContextFactory velocityRequestContextFactory, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.userFormatManager = (UserFormatManager)Assertions.notNull((String)"userFormatManager", (Object)userFormatManager);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.outlookDateManager = (OutlookDateManager)Assertions.notNull((String)"outlookDateManager", (Object)outlookDateManager);
        this.propertiesReference = new ResettableLazyReference<PropertySet>(){

            protected PropertySet create() throws Exception {
                return jiraPropertySetFactory.buildCachingDefaultPropertySet(DefaultReindexMessageManager.PS_KEY, true);
            }
        };
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public synchronized void onClearCache(ClearCacheEvent event) {
        this.propertiesReference.reset();
    }

    @Override
    public synchronized void pushMessage(User user, String i18nTask) {
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_USER, user == null ? "" : user.getName());
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_TASK, i18nTask);
        ((PropertySet)this.propertiesReference.get()).setDate(PS_KEY_TIME, this.getCurrentDate());
    }

    @Override
    public synchronized void clear() {
        if (((PropertySet)this.propertiesReference.get()).exists(PS_KEY_USER)) {
            ((PropertySet)this.propertiesReference.get()).remove(PS_KEY_TIME);
            ((PropertySet)this.propertiesReference.get()).remove(PS_KEY_TASK);
            ((PropertySet)this.propertiesReference.get()).remove(PS_KEY_USER);
        }
    }

    @Override
    public synchronized String getMessage(User user) {
        if (((PropertySet)this.propertiesReference.get()).exists(PS_KEY_USER)) {
            String userName = ((PropertySet)this.propertiesReference.get()).getString(PS_KEY_USER);
            String i18nTaskKey = ((PropertySet)this.propertiesReference.get()).getString(PS_KEY_TASK);
            Date time = ((PropertySet)this.propertiesReference.get()).getDate(PS_KEY_TIME);
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(i18n.getLocale());
            String userFullName = this.userFormatManager.formatUser(userName, "fullName", "fullName");
            String i18nTask = i18n.getText(i18nTaskKey);
            String timeString = outlookDate.formatDMYHMS(time);
            StringBuilder message = new StringBuilder();
            if (userFullName == null) {
                message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex.nouser", i18nTask, timeString));
            } else {
                message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex", userFullName, i18nTask, timeString));
            }
            message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
            message.append("<p>").append(i18n.getText("admin.notifications.complete.all.changes"));
            return message.toString();
        }
        return null;
    }

    String getContextPath() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }
}

