/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.bulkedit.operation.AbstractBulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.List;
import org.apache.log4j.Logger;
import webwork.dispatcher.ActionResult;

public class BulkDeleteOperation
extends AbstractBulkOperation
implements BulkOperation {
    protected static final Logger log = Logger.getLogger(BulkDeleteOperation.class);
    public static final String NAME = "BulkDelete";
    public static final String NAME_KEY = "bulk.delete.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.delete.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.delete.cannotperform";

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        PermissionManager permissionManager = ManagerFactory.getPermissionManager();
        for (int i = 0; i < selectedIssues.size(); ++i) {
            Issue issue = (Issue)selectedIssues.get(i);
            if (permissionManager.hasPermission(16, issue, remoteUser)) continue;
            return false;
        }
        return true;
    }

    public void perform(BulkEditBean bulkEditBean, User remoteUser) throws Exception {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (int i = 0; i < selectedIssues.size(); ++i) {
            Issue issue = (Issue)selectedIssues.get(i);
            if (ComponentAccessor.getIssueManager().getIssueObject(issue.getId()) != null) {
                boolean sendMail = bulkEditBean.isSendBulkNotification();
                ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.ISSUE_DELETE, EasyMap.build((Object)"issue", (Object)issue.getGenericValue(), (Object)"remoteUser", (Object)remoteUser, (Object)"sendMail", (Object)sendMail));
                ActionUtils.checkForErrors(aResult);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Not deleting issue with id '" + issue.getLong("id") + "' and key '" + issue.getString("key") + "' as it does not exist in the database (it could have been deleted earlier as it might be a subtask)."));
        }
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BulkDeleteOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }
}

