/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultUserService
implements UserService {
    private static final int MAX_FIELD_LENGTH = 255;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final JiraContactHelper jiraContactHelper;

    public DefaultUserService(UserUtil userUtil, PermissionManager permissionManager, ApplicationProperties applicationProperties, UserManager userManager, JiraContactHelper jiraContactHelper) {
        this.userUtil = userUtil;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.jiraContactHelper = jiraContactHelper;
    }

    public UserService.CreateUserValidationResult validateCreateUserForSignupOrSetup(User user, String username, String password, String confirmPassword, String email, String fullname) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            String link = this.getContactAdminLink(i18nBean);
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.external.managment", link));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, null));
        if (StringUtils.isEmpty((String)password)) {
            errors.addError(UserService.FieldName.PASSWORD, i18nBean.getText("signup.error.password.required"));
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdminPasswordRequired(User user, String username, String password, String confirmPassword, String email, String fullname) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, user)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.no.permission.to.create"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            String link = this.getContactAdminLink(i18nBean);
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.external.managment", link));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, null));
        if (StringUtils.isEmpty((String)password)) {
            errors.addError(UserService.FieldName.PASSWORD, i18nBean.getText("signup.error.password.required"));
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname, null);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(User user, String username, String password, String confirmPassword, String email, String fullname) {
        return this.validateCreateUserForAdmin(user, username, password, confirmPassword, email, fullname, null);
    }

    public UserService.CreateUserValidationResult validateCreateUserForAdmin(User user, String username, String password, String confirmPassword, String email, String fullname, Long directoryId) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, user)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.no.permission.to.create"));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            String link = this.getContactAdminLink(i18nBean);
            errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.external.managment", link));
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        errors.addErrorCollection(this.validateCreateUser(i18nBean, username, password, confirmPassword, email, fullname, directoryId));
        if (directoryId == null) {
            if (this.userManager.getWritableDirectories().size() == 0) {
                String link = this.getContactAdminLink(i18nBean);
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.external.managment", link));
            }
        } else {
            Directory directory = this.userManager.getDirectory(directoryId);
            if (directory == null) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.no.such.directory", (Object)directoryId));
            } else if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.cannot.add.user.read.only.directory", directory.getName()));
            }
        }
        if (errors.hasAnyErrors()) {
            return new UserService.CreateUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.CreateUserValidationResult(username, password, email, fullname, directoryId);
    }

    private ErrorCollection validateCreateUser(I18nHelper i18nBean, String username, String password, String confirmPassword, String email, String fullname, Long directoryId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (StringUtils.isEmpty((String)email)) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.required"));
        } else if (email.length() > 255) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.greater.than.max.chars"));
        } else if (!TextUtils.verifyEmail((String)email)) {
            errors.addError(UserService.FieldName.EMAIL, i18nBean.getText("signup.error.email.valid"));
        }
        if (StringUtils.isEmpty((String)fullname)) {
            errors.addError(UserService.FieldName.FULLNAME, i18nBean.getText("signup.error.fullname.required"));
        } else if (fullname.length() > 255) {
            errors.addError(UserService.FieldName.FULLNAME, i18nBean.getText("signup.error.full.name.greater.than.max.chars"));
        }
        if (StringUtils.isEmpty((String)username)) {
            errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.required"));
        } else if (username.length() > 255) {
            errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.greater.than.max.chars"));
        } else {
            for (int i = 0; i < username.length(); ++i) {
                char c = username.charAt(i);
                if (!Character.isUpperCase(c)) continue;
                errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.allLowercase"));
                break;
            }
            if (!errors.getErrors().containsKey(UserService.FieldName.NAME)) {
                if (directoryId == null) {
                    if (this.userUtil.userExists(username)) {
                        errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.exists"));
                    }
                } else if (this.userManager.findUserInDirectory(username, directoryId) != null) {
                    errors.addError(UserService.FieldName.NAME, i18nBean.getText("signup.error.username.exists"));
                }
            }
        }
        if (!(!StringUtils.isNotEmpty((String)confirmPassword) && !StringUtils.isNotEmpty((String)password) || password != null && password.equals(confirmPassword))) {
            errors.addError(UserService.FieldName.CONFIRM_PASSWORD, i18nBean.getText("signup.error.password.mustmatch"));
        }
        return errors;
    }

    public User createUserNoNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        String username = result.getUsername();
        String password = result.getPassword();
        String email = result.getEmail();
        String fullname = result.getFullname();
        Long directoryId = result.getDirectoryId();
        return this.userUtil.createUserNoNotification(username, password, email, fullname, directoryId);
    }

    public User createUserFromSignup(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 0);
    }

    public User createUserWithNotification(UserService.CreateUserValidationResult result) throws PermissionException, CreateException {
        return this.createUserWithNotification(result, 1);
    }

    private User createUserWithNotification(UserService.CreateUserValidationResult result, int eventType) throws PermissionException, CreateException {
        Assertions.notNull((String)"You can not create a user, validation result", (Object)result);
        Assertions.stateTrue((String)"You can not create a user with an invalid validation result.", (boolean)result.isValid());
        String username = result.getUsername();
        String password = result.getPassword();
        String email = result.getEmail();
        String fullname = result.getFullname();
        Long directoryId = result.getDirectoryId();
        return this.userUtil.createUserWithNotification(username, password, email, fullname, directoryId, eventType);
    }

    public UserService.DeleteUserValidationResult validateDeleteUser(User loggedInUser, String username) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.delete.no.permission"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            String link = this.getContactAdminLink(i18nBean);
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.external.user.mgmt", link));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (username == null || "".equals(username)) {
            errors.addError("username", i18nBean.getText("admin.errors.users.cannot.delete.due.to.invalid.username"));
        }
        if (errors.hasAnyErrors()) {
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        if (loggedInUser.getName().equalsIgnoreCase(username)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.currently.logged.in"));
        }
        if (errors.hasAnyErrors()) {
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        User userForDelete = this.userUtil.getUser(username);
        if (userForDelete == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.users.user.does.not.exist"));
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        try {
            long numberOfProjectsUserLeads;
            long numberOfAssignedIssues;
            long numberOfReportedIssues = this.userUtil.getNumberOfReportedIssuesIgnoreSecurity(loggedInUser, userForDelete);
            if (numberOfReportedIssues > 0L) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.reported.issues", "'" + username + "'", "" + numberOfReportedIssues));
            }
            if ((numberOfAssignedIssues = this.userUtil.getNumberOfAssignedIssuesIgnoreSecurity(loggedInUser, userForDelete)) > 0L) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.assigned.issues", "'" + username + "'", "" + numberOfAssignedIssues));
            }
            if ((numberOfProjectsUserLeads = (long)this.userUtil.getProjectsLeadBy(userForDelete).size()) > 0L) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.project.lead", "'" + username + "'", "" + numberOfProjectsUserLeads));
            }
            if (this.userUtil.isNonSysAdminAttemptingToDeleteSysAdmin(loggedInUser, userForDelete)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.users.cannot.delete.due.to.sysadmin"));
            }
        }
        catch (SearchException e) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.exception.occured.validating") + " " + (Object)((Object)e));
        }
        if (errors.hasAnyErrors()) {
            return new UserService.DeleteUserValidationResult((ErrorCollection)errors);
        }
        return new UserService.DeleteUserValidationResult(userForDelete);
    }

    public void removeUser(User loggedInUser, UserService.DeleteUserValidationResult result) {
        Assertions.notNull((String)"You can not remove a user with a null validation result.", (Object)result);
        Assertions.stateTrue((String)"You can not remove a user with an invalid validation result.", (boolean)result.isValid());
        User userForDelete = result.getUser();
        this.userUtil.removeUser(loggedInUser, userForDelete);
    }

    I18nHelper getI18nBean(User user) {
        return new I18nBean(user);
    }

    private String getContactAdminLink(I18nHelper i18n) {
        return this.jiraContactHelper.getAdministratorContactMessage(i18n);
    }
}

