/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.attachment;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.List;

public class DefaultAttachmentService
implements AttachmentService {
    private static final String ERROR_ATTACHMENT_DELETE_NON_EDITABLE_ISSUE = "attachment.service.error.delete.issue.non.editable";
    private static final String ERROR_ATTACHMENT_CREATE_NON_EDITABLE_ISSUE = "attachment.service.error.create.issue.non.editable";
    private static final String ERROR_ATTACHMENT_MANAGE_NO_PERMISSION = "attachment.service.error.manage.no.permission";
    private static final String ERROR_ATTACHMENT_DELETE_NO_PERMISSION = "attachment.service.error.delete.no.permission";
    private static final String ERROR_ATTACHMENT_CREATE_NO_PERMISSION = "attachment.service.error.create.no.permission";
    private static final String ERROR_ATTACHMENTS_DISABLED = "attachment.service.error.attachments.disabled";
    private static final String ERROR_SCREENSHOT_APPLET_DISABLED = "attachment.service.error.screenshot.applet.disabled";
    private static final String ERROR_SCREENSHOT_APPLET_UNSUPPORTED_OS = "attachment.service.error.screenshot.applet.unsupported.os";
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueUpdater issueUpdater;
    private final IssueManager issueManager;

    public DefaultAttachmentService(AttachmentManager attachmentManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, IssueUpdater issueUpdater, IssueManager issueManager) {
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueUpdater = issueUpdater;
        this.issueManager = issueManager;
    }

    public boolean canDeleteAttachment(JiraServiceContext jiraServiceContext, Long attachmentId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        User user = jiraServiceContext.getLoggedInUser();
        Attachment attachment = this.getAndVerifyAttachment(attachmentId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        Issue issue = this.getAndVerifyIssue(attachment, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.isIssueInEditableWorkflowState(issue)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_DELETE_NON_EDITABLE_ISSUE));
            return false;
        }
        if (this.userHasAttachmentDeleteAllPermission(issue, user)) {
            return true;
        }
        if (this.userHasAttachmentDeleteOwnPermission(issue, user) && this.isUserAttachmentAuthor(attachment, user)) {
            return true;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_DELETE_NO_PERMISSION, attachmentId.toString()));
        return false;
    }

    public boolean canManageAttachments(JiraServiceContext jiraServiceContext, Issue issue) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        User user = jiraServiceContext.getLoggedInUser();
        boolean hasDeletePerm = this.canDeleteAnyAttachment(user, issue, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        if (!this.isAttachmentsEnabledAndPathSet()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENTS_DISABLED));
            return false;
        }
        boolean hasCreatePerm = this.userHasCreateAttachmentPermission(issue, user);
        if (hasCreatePerm || hasDeletePerm) {
            return true;
        }
        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_MANAGE_NO_PERMISSION));
        return false;
    }

    public void delete(JiraServiceContext jiraServiceContext, Long attachmentId) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        User user = jiraServiceContext.getLoggedInUser();
        Attachment attachment = this.getAndVerifyAttachment(attachmentId, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        Issue issue = this.getAndVerifyIssue(attachment, errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return;
        }
        try {
            this.attachmentManager.deleteAttachment(attachment);
        }
        catch (RemoveException e) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.delete.attachment.failed", attachmentId.toString()));
            return;
        }
        IssueUpdateBean issueUpdateBean = this.constructIssueUpdateBeanForAttachmentDelete(attachment, issue, user);
        try {
            this.issueUpdater.doUpdate(issueUpdateBean, true);
        }
        catch (JiraException e) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.issue.update.failed", issue.getKey()));
        }
    }

    public Attachment getAttachment(JiraServiceContext jiraServiceContext, Long attachmentId) throws AttachmentNotFoundException {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        return this.getAndVerifyAttachment(attachmentId, errorCollection);
    }

    public boolean canCreateAttachments(JiraServiceContext jiraServiceContext, Project project) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (project == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.project"));
            return false;
        }
        if (!this.isAttachmentsEnabledAndPathSet()) {
            errorCollection.addErrorMessage(this.getText(ERROR_ATTACHMENTS_DISABLED));
            return false;
        }
        if (!this.permissionManager.hasPermission(19, project, jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.create.no.permission.project"));
            return false;
        }
        return true;
    }

    public boolean canCreateTemporaryAttachments(JiraServiceContext jiraServiceContext, Issue issue) {
        return this.canCreateAttachmentsWithoutWorkflow(jiraServiceContext, issue);
    }

    public boolean canCreateAttachments(JiraServiceContext jiraServiceContext, Issue issue) {
        if (!this.canCreateAttachmentsWithoutWorkflow(jiraServiceContext, issue)) {
            return false;
        }
        if (!this.isIssueInEditableWorkflowState(issue)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(ERROR_ATTACHMENT_CREATE_NON_EDITABLE_ISSUE));
            return false;
        }
        return true;
    }

    private boolean canCreateAttachmentsWithoutWorkflow(JiraServiceContext jiraServiceContext, Issue issue) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.issue"));
            return false;
        }
        if (!this.isAttachmentsEnabledAndPathSet()) {
            errorCollection.addErrorMessage(this.getText(ERROR_ATTACHMENTS_DISABLED));
            return false;
        }
        if (!this.userHasCreateAttachmentPermission(issue, jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText(ERROR_ATTACHMENT_CREATE_NO_PERMISSION));
            return false;
        }
        return true;
    }

    public boolean canAttachScreenshots(JiraServiceContext jiraServiceContext, Issue issue) {
        if (!this.canCreateAttachments(jiraServiceContext, issue)) {
            return false;
        }
        return this.isScreenshotAppletEnabledAndSupportedByOS(jiraServiceContext);
    }

    boolean isIssueInEditableWorkflowState(Issue issue) {
        return this.issueManager.isEditable(issue);
    }

    boolean isScreenshotAppletEnabledAndSupportedByOS(JiraServiceContext jiraServiceContext) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.attachmentManager.isScreenshotAppletEnabled()) {
            errorCollection.addErrorMessage(this.getText(ERROR_SCREENSHOT_APPLET_DISABLED));
            return false;
        }
        if (!this.attachmentManager.isScreenshotAppletSupportedByOS()) {
            errorCollection.addErrorMessage(this.getText(ERROR_SCREENSHOT_APPLET_UNSUPPORTED_OS));
            return false;
        }
        return true;
    }

    boolean isAttachmentsEnabledAndPathSet() {
        return this.attachmentManager.attachmentsEnabled();
    }

    Issue getAndVerifyIssue(Attachment attachment, ErrorCollection errorCollection) {
        Issue issue = attachment.getIssueObject();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.issue.for.attachment", attachment.getId().toString()));
            return null;
        }
        return issue;
    }

    Attachment getAndVerifyAttachment(Long attachmentId, ErrorCollection errorCollection) {
        if (attachmentId == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.attachment.id"));
            return null;
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.attachment", attachmentId.toString()));
        }
        return attachment;
    }

    IssueUpdateBean constructIssueUpdateBeanForAttachmentDelete(Attachment attachment, Issue issue, User user) {
        ChangeItemBean changeItem = new ChangeItemBean("jira", "Attachment", attachment.getId().toString(), attachment.getFilename(), null, null);
        List changeItemBeans = EasyList.build((Object)changeItem);
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), issue.getGenericValue(), EventType.ISSUE_UPDATED_ID, user);
        issueUpdateBean.setChangeItems((Collection)changeItemBeans);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        return issueUpdateBean;
    }

    boolean userHasAttachmentDeleteAllPermission(Issue issue, User user) {
        return this.permissionManager.hasPermission(38, issue, user);
    }

    boolean userHasAttachmentDeleteOwnPermission(Issue issue, User user) {
        return this.permissionManager.hasPermission(39, issue, user);
    }

    boolean userHasCreateAttachmentPermission(Issue issue, User user) {
        return this.permissionManager.hasPermission(19, issue, user);
    }

    boolean isUserAttachmentAuthor(Attachment attachment, User user) {
        String attachmentAuthor = attachment.getAuthor();
        if (attachmentAuthor == null && Users.isAnonymous((User)user)) {
            return true;
        }
        if (attachmentAuthor == null || Users.isAnonymous((User)user)) {
            return false;
        }
        return attachmentAuthor.equals(user.getName());
    }

    boolean isAuthorOfAtLeastOneAttachment(Issue issue, User user) {
        List attachments = this.attachmentManager.getAttachments(issue);
        for (Attachment attachment : attachments) {
            if (!this.isUserAttachmentAuthor(attachment, user)) continue;
            return true;
        }
        return false;
    }

    boolean canDeleteAnyAttachment(User user, Issue issue, ErrorCollection errorCollection) {
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText("attachment.service.error.null.issue"));
            return false;
        }
        if (this.userHasAttachmentDeleteAllPermission(issue, user)) {
            return true;
        }
        if (this.userHasAttachmentDeleteOwnPermission(issue, user)) {
            return this.isAuthorOfAtLeastOneAttachment(issue, user);
        }
        return false;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

