/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtilsBean;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueService
implements IssueService {
    private static final Logger log = Logger.getLogger(DefaultIssueService.class);
    private final IssueFactory issueFactory;
    private final IssueCreationHelperBean issueCreationHelperBean;
    private final FieldManager fieldManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final WorkflowManager workflowManager;
    private final IssueUtilsBean issueUtilsBean;

    public DefaultIssueService(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, FieldManager fieldManager, IssueManager issueManager, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, WorkflowManager workflowManager, IssueUtilsBean issueUtilsBean) {
        this.issueFactory = issueFactory;
        this.issueCreationHelperBean = issueCreationHelperBean;
        this.fieldManager = fieldManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.workflowManager = workflowManager;
        this.issueUtilsBean = issueUtilsBean;
    }

    public IssueService.IssueResult getIssue(User user, Long issueId) {
        I18nHelper i18n = this.getI18n(user);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        return new IssueService.IssueResult(this.getIssue(user, issue, i18n, (ErrorCollection)errors), (ErrorCollection)errors);
    }

    public IssueService.IssueResult getIssue(User user, String issueKey) {
        I18nHelper i18n = this.getI18n(user);
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        return new IssueService.IssueResult(this.getIssue(user, issue, i18n, (ErrorCollection)errors), (ErrorCollection)errors);
    }

    public IssueService.CreateValidationResult validateCreate(User user, IssueInputParameters issueInputParameters) {
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("Can not validate issue creation with a null IssueInputParameters.");
        }
        MutableIssue issue = this.constructNewIssue();
        return this.validateCreate(user, issue, issueInputParameters);
    }

    public IssueService.CreateValidationResult validateSubTaskCreate(User user, Long parentId, IssueInputParameters issueInputParameters) {
        MutableIssue issue = this.constructNewIssue();
        issue.setParentId(parentId);
        return this.validateCreate(user, issue, issueInputParameters);
    }

    public IssueService.IssueResult create(User user, IssueService.CreateValidationResult createValidationResult) {
        return this.create(user, createValidationResult, null);
    }

    public IssueService.IssueResult create(User user, IssueService.CreateValidationResult createValidationResult, String initialWorkflowActionName) {
        if (createValidationResult == null) {
            throw new IllegalArgumentException("You can not create an issue with a null validation result.");
        }
        if (!createValidationResult.isValid()) {
            throw new IllegalStateException("You can not create an issue with an invalid validation result.");
        }
        if (createValidationResult.getIssue() == null) {
            throw new IllegalArgumentException("You can not create a null issue.");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        MutableIssue issue = createValidationResult.getIssue();
        fields.put("issue", issue);
        MutableIssue originalIssue = this.issueManager.getIssueObject(issue.getId());
        fields.put("originalissueobject", originalIssue);
        fields.put("pkey", issue.getProjectObject().getKey());
        if (initialWorkflowActionName != null) {
            fields.put("submitbutton", initialWorkflowActionName);
        }
        try {
            GenericValue newIssueGV = this.issueManager.createIssue(user, fields);
            return new IssueService.IssueResult(this.issueFactory.getIssue(newIssueGV));
        }
        catch (CreateException e) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            this.handleCreateException(this.getI18n(user), (ErrorCollection)errors, e);
            return new IssueService.IssueResult(null, (ErrorCollection)errors);
        }
    }

    public IssueService.UpdateValidationResult validateUpdate(User user, Long issueId, IssueInputParameters issueInputParameters) {
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide a non-null issueInputParameters to update an issue.");
        }
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        if (!this.hasPermissionToEdit(user, (Issue)issue, i18n, (ErrorCollection)errors)) {
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder);
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableIssue copiedIssue = this.copyIssue(issue);
        MutableIssue updatedIssue = this.validateAndUpdateIssueFromFields(user, copiedIssue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n, this.getUpdateFieldScreenRenderer(user, (Issue)issue), true);
        if (errorCollection.hasAnyErrors()) {
            updatedIssue = null;
            errors.addErrorCollection((ErrorCollection)errorCollection);
        }
        return new IssueService.UpdateValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder);
    }

    public IssueService.IssueResult update(User user, IssueService.UpdateValidationResult issueValidationResult) {
        return this.update(user, issueValidationResult, EventDispatchOption.ISSUE_UPDATED, true);
    }

    public IssueService.IssueResult update(User user, IssueService.UpdateValidationResult issueValidationResult, EventDispatchOption eventDispatchOption, boolean sendMail) {
        MutableIssue updatedIssue;
        if (issueValidationResult == null) {
            throw new IllegalArgumentException("You can not update an issue with a null validation result.");
        }
        if (!issueValidationResult.isValid()) {
            throw new IllegalStateException("You can not update an issue with an invalid validation result.");
        }
        MutableIssue issue = issueValidationResult.getIssue();
        if (eventDispatchOption == null) {
            throw new IllegalArgumentException("You can not update an issue with a null EventDispatchOption.");
        }
        if (issue == null) {
            throw new IllegalArgumentException("You can not update a null issue.");
        }
        try {
            updatedIssue = (MutableIssue)this.issueManager.updateIssue(user, issue, eventDispatchOption, sendMail);
        }
        catch (UpdateException e) {
            log.error((Object)("Exception occurred editing issue: " + (Object)((Object)e)), (Throwable)e);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.getI18n(user).getText("admin.errors.issues.exception.occured", (Object)e));
            return new IssueService.IssueResult(null, (ErrorCollection)errors);
        }
        return new IssueService.IssueResult(updatedIssue);
    }

    public IssueService.DeleteValidationResult validateDelete(User user, Long issueId) {
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.delete.issue.is.null"));
            return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.delete.issue.is.null"));
            return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
        }
        if (this.hasPermissionToDelete(user, (Issue)issue, i18n, (ErrorCollection)errors)) {
            return new IssueService.DeleteValidationResult(issue, (ErrorCollection)errors);
        }
        return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
    }

    public ErrorCollection delete(User user, IssueService.DeleteValidationResult issueValidationResult) {
        return this.delete(user, issueValidationResult, EventDispatchOption.ISSUE_DELETED, true);
    }

    public ErrorCollection delete(User user, IssueService.DeleteValidationResult issueValidationResult, EventDispatchOption eventDispatchOption, boolean sendMail) {
        if (eventDispatchOption == null) {
            throw new IllegalArgumentException("You can not delete an issue with a null EventDispatchOption.");
        }
        if (issueValidationResult == null) {
            throw new IllegalArgumentException("You can not delete an issue with a null IssueValidationResult.");
        }
        if (!issueValidationResult.isValid()) {
            throw new IllegalStateException("You can not delete an issue with an invalid validation result.");
        }
        if (issueValidationResult.getIssue() == null) {
            throw new IllegalArgumentException("You can not delete a null issue.");
        }
        MutableIssue issue = issueValidationResult.getIssue();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        try {
            this.issueManager.deleteIssue(user, issue, eventDispatchOption, sendMail);
        }
        catch (RemoveException e) {
            log.error((Object)("There was an exception while trying to delete the issue '" + issue.getKey() + "'."), (Throwable)e);
            errors.addErrorMessage(this.getI18n(user).getText("issue.service.issue.deletion.error", issue.getKey()));
        }
        return errors;
    }

    public boolean isEditable(Issue issue, User user) {
        return this.issueManager.isEditable(issue, user);
    }

    public IssueService.TransitionValidationResult validateTransition(User user, Long issueId, int actionId, IssueInputParameters issueInputParameters) {
        MutableIssue updatedIssue;
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide a non-null issueInputParameters.");
        }
        I18nHelper i18n = this.getI18n(user);
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.is.null"));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.is.null"));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        ActionDescriptor actionDescriptor = this.getActionDescriptor((Issue)issue, actionId);
        if (actionDescriptor == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.no.action", String.valueOf(actionId)));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        if (!this.issueUtilsBean.isValidAction((Issue)issue, actionId)) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.action.invalid", actionDescriptor.getName(), issue.getKey()));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        if (StringUtils.isNotEmpty((String)actionDescriptor.getView())) {
            updatedIssue = this.validateAndUpdateIssueFromFields(user, issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errors, i18n, this.getTransitionFieldScreenRenderer(user, (Issue)issue, actionDescriptor), false);
            if (errors.hasAnyErrors()) {
                return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
            }
        } else {
            updatedIssue = issue;
        }
        Map<String, Object> additionalParams = this.createAdditionalParameters(user, fieldValuesHolder);
        return new IssueService.TransitionValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder, additionalParams, actionId);
    }

    public IssueService.IssueResult transition(User user, IssueService.TransitionValidationResult transitionResult) {
        if (transitionResult == null) {
            throw new IllegalArgumentException("You must provide a non-null transition result to transition an issue through workflow.");
        }
        if (!transitionResult.isValid()) {
            throw new IllegalStateException("You can not transition an issue with an invalid validation result.");
        }
        MutableIssue issue = transitionResult.getIssue();
        if (issue == null) {
            throw new IllegalArgumentException("You can not transition a null issue.");
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SimpleWorkflowProgressAware workflowProgressAware = new SimpleWorkflowProgressAware(transitionResult.getActionId(), user, (ErrorCollection)errorCollection, transitionResult.getAdditionInputs(), issue, issue.getProject());
        this.workflowManager.doWorkflowAction((WorkflowProgressAware)workflowProgressAware);
        return new IssueService.IssueResult(this.issueManager.getIssueObject(issue.getId()), (ErrorCollection)errorCollection);
    }

    private void handleCreateException(I18nHelper i18n, ErrorCollection errors, CreateException createException) {
        String errMsg = i18n.getText("admin.errors.issues.error.creating", createException.getMessage());
        Throwable cause = createException.getCause();
        if (cause instanceof InvalidInputException) {
            InvalidInputException inputException = (InvalidInputException)cause;
            this.handleInvalidInputException(errors, inputException);
        } else {
            errors.addErrorMessage(errMsg);
        }
    }

    private void handleInvalidInputException(ErrorCollection errors, InvalidInputException inputException) {
        for (String string : inputException.getGenericErrors()) {
            errors.addErrorMessage(string);
        }
        for (Map.Entry entry : inputException.getErrors().entrySet()) {
            errors.addError((String)entry.getKey(), (String)entry.getValue());
        }
    }

    MutableIssue validateAndUpdateIssueFromFields(User user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer, boolean updateComment) {
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder);
        SimpleErrorCollection localCollection = new SimpleErrorCollection();
        this.validateAndPopulateParams(user, issue, issueInputParameters, fieldValuesHolder, (OperationContext)operationContext, (ErrorCollection)localCollection, i18n, fieldScreenRenderer);
        if (!localCollection.hasAnyErrors()) {
            this.updateIssueFromFields(fieldScreenRenderer, issue, user, fieldValuesHolder, updateComment);
        } else {
            issue = null;
            errorCollection.addErrorCollection((ErrorCollection)localCollection);
        }
        return issue;
    }

    IssueService.CreateValidationResult validateCreate(User user, MutableIssue issue, IssueInputParameters issueInputParameters) {
        I18nHelper i18n = this.getI18n(user);
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide non-null issue input parameters to validate an issue.");
        }
        if (issue == null) {
            throw new IllegalArgumentException("You must provide a non-null issue to validate and populate.");
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        if (!this.licenseInvalidForIssueCreation((ErrorCollection)errorCollection, i18n)) {
            issue = this.validateAndSetProject(issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
            issue = this.validateAndSetIssueType(issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
            if (!errorCollection.hasAnyErrors() && this.hasPermissionToCreate(user, issue.getProjectObject(), i18n, (ErrorCollection)errorCollection)) {
                issue = this.validateAndCreateIssueFromFields(user, issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
            }
        }
        if (errorCollection.hasAnyErrors()) {
            issue = null;
        }
        return new IssueService.CreateValidationResult(issue, (ErrorCollection)errorCollection, fieldValuesHolder);
    }

    Map<String, Object> cloneFieldValuesHolder(IssueInputParameters issueInputParameters) {
        HashMap<String, Object> clonedFieldValuesHolder = new HashMap<String, Object>();
        clonedFieldValuesHolder.putAll(issueInputParameters.getFieldValuesHolder());
        return clonedFieldValuesHolder;
    }

    MutableIssue validateAndCreateIssueFromFields(User user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        FieldScreenRenderer fieldScreenRenderer = this.getCreateFieldScreenRenderer(user, (Issue)issue);
        Collection providedFields = issueInputParameters.getProvidedFields();
        if (providedFields == null) {
            providedFields = this.issueCreationHelperBean.getProvidedFieldNames(user, (Issue)issue);
        }
        this.issueCreationHelperBean.validateCreateIssueFields((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), providedFields, (Issue)issue, fieldScreenRenderer, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters.getActionParameters(), i18n);
        if (!errorCollection.hasAnyErrors()) {
            this.issueCreationHelperBean.updateIssueFromFieldValuesHolder(fieldScreenRenderer, user, issue, fieldValuesHolder);
        }
        return issue;
    }

    MutableIssue validateAndSetIssueType(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        this.issueCreationHelperBean.validateIssueType((Issue)issue, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters.getActionParameters(), errorCollection, i18n);
        if (!errorCollection.hasAnyErrors()) {
            issue.setIssueTypeId(issueInputParameters.getIssueTypeId());
        }
        return issue;
    }

    MutableIssue validateAndSetProject(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        this.issueCreationHelperBean.validateProject((Issue)issue, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters.getActionParameters(), errorCollection, i18n);
        if (!errorCollection.hasAnyErrors()) {
            issue.setProjectId(issueInputParameters.getProjectId());
        }
        return issue;
    }

    void updateIssueFromFields(FieldScreenRenderer fieldScreenRenderer, MutableIssue issue, User user, Map<String, Object> fieldValuesHolder, boolean updateComment) {
        if (updateComment) {
            this.updateIssueWithComment(issue, user, fieldValuesHolder);
        }
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                fieldScreenRenderLayoutItem.getOrderableField().updateIssue(fieldScreenRenderLayoutItem.getFieldLayoutItem(), issue, fieldValuesHolder);
            }
        }
    }

    void validateAndPopulateParams(User user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer) {
        if (issueInputParameters.getCommentValue() != null) {
            OrderableField field = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
            field.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
            field.validateParams(operationContext, errorCollection, i18n, (Issue)issue, this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, field));
        }
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                if (retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId())) {
                    orderableField.populateFromIssue(fieldValuesHolder, (Issue)issue);
                } else {
                    orderableField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
                }
                orderableField.validateParams(operationContext, errorCollection, i18n, (Issue)issue, fieldScreenRenderLayoutItem);
            }
        }
    }

    boolean licenseInvalidForIssueCreation(ErrorCollection errorCollection, I18nHelper i18n) {
        SimpleErrorCollection errorCollection1 = new SimpleErrorCollection();
        this.issueCreationHelperBean.validateLicense((ErrorCollection)errorCollection1, i18n);
        if (errorCollection1.hasAnyErrors()) {
            errorCollection.addErrorCollection((ErrorCollection)errorCollection1);
            return true;
        }
        return false;
    }

    boolean hasPermissionToEdit(User user, Issue issue, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.issueManager.isEditable(issue, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("editissue.error.no.edit.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToView(User user, Issue issue, I18nHelper i18n, ErrorCollection errorCollection) {
        boolean hasPermission = this.permissionManager.hasPermission(10, issue, user);
        if (!hasPermission) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.issues.no.permission.to.see"), ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToCreate(User user, Project project, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.permissionManager.hasPermission(11, project, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("createissue.projectnopermission"), ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToDelete(User user, Issue issue, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.permissionManager.hasPermission(16, issue, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("admin.errors.issues.no.permission.to.delete"), ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    MutableIssue constructNewIssue() {
        return this.issueFactory.getIssue();
    }

    MutableIssue copyIssue(MutableIssue issue) {
        return this.issueFactory.getIssue(issue.getGenericValue());
    }

    FieldScreenRenderer getCreateFieldScreenRenderer(User user, Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, false);
    }

    FieldScreenRenderer getUpdateFieldScreenRenderer(User user, Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, false);
    }

    FieldScreenRenderer getTransitionFieldScreenRenderer(User user, Issue issue, ActionDescriptor actionDescriptor) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, actionDescriptor);
    }

    MutableIssue getIssue(User user, MutableIssue issue, I18nHelper i18n, ErrorCollection errorCollection) {
        if (issue == null) {
            errorCollection.addErrorMessage(i18n.getText("issue.service.issue.wasdeleted"));
        } else if (this.hasPermissionToView(user, (Issue)issue, i18n, errorCollection)) {
            return issue;
        }
        return null;
    }

    void updateIssueWithComment(MutableIssue issue, User user, Map<String, Object> fieldValuesHolder) {
        OrderableField commentField = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
        FieldLayoutItem fieldLayoutItem = this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, commentField).getFieldLayoutItem();
        commentField.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
    }

    FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(User user, Issue issue, OrderableField field) {
        FieldScreenRenderer renderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, false);
        return renderer.getFieldScreenRenderLayoutItem(field);
    }

    ActionDescriptor getActionDescriptor(Issue issue, int actionId) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
        if (workflow == null) {
            return null;
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getAction(actionId);
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }

    Map<String, Object> createAdditionalParameters(User user, Map<String, Object> fieldValuesHolder) {
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        additionalParams.put("username", user != null ? user.getName() : null);
        CommentSystemField commentSystemField = (CommentSystemField)this.fieldManager.getOrderableField("comment");
        commentSystemField.populateAdditionalInputs(fieldValuesHolder, additionalParams);
        return additionalParams;
    }

    private class SimpleWorkflowProgressAware
    implements WorkflowProgressAware {
        private int action;
        private final User remoteUser;
        private final ErrorCollection errorCollection;
        private final Map additionalInputs;
        private final MutableIssue issue;
        private final GenericValue project;

        private SimpleWorkflowProgressAware(int action, User remoteUser, ErrorCollection errorCollection, Map additionalInputs, MutableIssue issue, GenericValue project) {
            this.action = action;
            this.remoteUser = remoteUser;
            this.errorCollection = errorCollection;
            this.additionalInputs = additionalInputs;
            this.issue = issue;
            this.project = project;
        }

        public User getRemoteUser() {
            return this.remoteUser;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int action) {
            this.action = action;
        }

        public void addErrorMessage(String error) {
            this.errorCollection.addErrorMessage(error);
        }

        public void addError(String name, String error) {
            this.errorCollection.addError(name, error);
        }

        public Map getAdditionalInputs() {
            return this.additionalInputs;
        }

        public MutableIssue getIssue() throws Exception {
            return this.issue;
        }

        public GenericValue getProject() throws Exception {
            return this.project;
        }
    }
}

