/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.association;

import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class NodeAssociationStoreImpl
implements NodeAssociationStore {
    private final OfBizDelegator ofBizDelegator;

    public NodeAssociationStoreImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public List<GenericValue> getSinksFromSource(GenericValue source, String sinkEntityName, String associationType) throws DataAccessException {
        if (source == null) {
            throw new IllegalArgumentException("Source GenericValue can not be null.");
        }
        return this.getSinksFromSource(source.getEntityName(), source.getLong("id"), sinkEntityName, associationType);
    }

    @Override
    public List<GenericValue> getSinksFromSource(String sourceEntityName, Long sourceNodeId, String sinkEntityName, String associationType) {
        List<GenericValue> result = this.getAssociationsFromSource(sourceEntityName, sourceNodeId, sinkEntityName, associationType);
        ArrayList<GenericValue> outList = new ArrayList<GenericValue>(result.size());
        for (GenericValue value : result) {
            GenericValue genericValue = this.ofBizDelegator.findByPrimaryKey(sinkEntityName, value.getLong("sinkNodeId"));
            if (genericValue == null) continue;
            outList.add(genericValue);
        }
        return outList;
    }

    @Override
    public List<GenericValue> getSourcesFromSink(GenericValue sink, String sourceName, String associationType) throws DataAccessException {
        Assertions.notNull((String)"sink", (Object)sink);
        List<GenericValue> result = this.getAssociationsFromSink(sink, associationType, sourceName);
        ArrayList<GenericValue> outList = new ArrayList<GenericValue>(result.size());
        for (GenericValue value : result) {
            GenericValue genericValue = this.ofBizDelegator.findByPrimaryKey(sourceName, value.getLong("sourceNodeId"));
            if (genericValue == null) continue;
            outList.add(genericValue);
        }
        return outList;
    }

    @Override
    public GenericValue createAssociation(GenericValue source, GenericValue sink, String associationType) throws DataAccessException {
        return this.createAssociation(source.getEntityName(), source.getLong("id"), sink.getEntityName(), sink.getLong("id"), associationType);
    }

    @Override
    public void createAssociation(NodeAssocationType type, Long sourceNodeId, Long sinkNodeId) {
        this.createAssociation(type.getSourceEntityName(), sourceNodeId, type.getSinkEntityName(), sinkNodeId, type.getName());
    }

    @Override
    public GenericValue createAssociation(String sourceNodeEntity, Long sourceNodeId, String sinkNodeEntity, Long sinkNodeId, String associationType) throws DataAccessException {
        GenericValue association = this.getAssociation(sourceNodeEntity, sourceNodeId, sinkNodeEntity, sinkNodeId, associationType);
        if (association == null) {
            association = this.ofBizDelegator.makeValue("NodeAssociation");
            association.setFields(UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)sourceNodeId, (String)"sourceNodeEntity", (Object)sourceNodeEntity, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity));
            try {
                association.create();
            }
            catch (GenericEntityException ex) {
                throw new DataAccessException((Throwable)ex);
            }
        }
        return association;
    }

    @Override
    public void removeAssociation(NodeAssocationType type, Long sourceNodeId, Long sinkNodeId) {
        this.removeAssociation(type.getName(), type.getSourceEntityName(), sourceNodeId, type.getSinkEntityName(), sinkNodeId);
    }

    @Override
    public void removeAssociation(GenericValue source, GenericValue sink, String associationType) throws DataAccessException {
        this.removeAssociation(associationType, source.getEntityName(), source.getLong("id"), sink.getEntityName(), sink.getLong("id"));
    }

    private void removeAssociation(String associationType, String sourceEntityName, Long sourceNodeId, String sinkEntityName, Long sinkNodeId) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("associationType", associationType);
        fields.put("sourceNodeEntity", sourceEntityName);
        fields.put("sourceNodeId", sourceNodeId);
        fields.put("sinkNodeEntity", sinkEntityName);
        fields.put("sinkNodeId", sinkNodeId);
        this.ofBizDelegator.removeByAnd("NodeAssociation", fields);
    }

    @Override
    public void removeAssociationsFromSource(GenericValue source) throws DataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sourceNodeId", source.getLong("id"));
        fields.put("sourceNodeEntity", source.getEntityName());
        this.ofBizDelegator.removeByAnd("NodeAssociation", fields);
    }

    @Override
    public void removeAssociationsFromSink(GenericValue sink) throws DataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        this.ofBizDelegator.removeByAnd("NodeAssociation", fields);
    }

    @Override
    public void swapAssociation(String sourceEntityName, String associationType, GenericValue fromSink, GenericValue toSink) throws DataAccessException {
        List<GenericValue> sources = this.getSourcesFromSink(fromSink, sourceEntityName, associationType);
        this.swapAssociation(sources, associationType, fromSink, toSink);
    }

    @Override
    public void swapAssociation(List<GenericValue> entities, String associationType, GenericValue fromSink, GenericValue toSink) throws DataAccessException {
        for (GenericValue entity : entities) {
            this.createAssociation(entity, toSink, associationType);
            this.removeAssociation(entity, fromSink, associationType);
        }
    }

    @Override
    public GenericValue getAssociation(GenericValue source, GenericValue sink, String associationType) throws DataAccessException {
        return this.getAssociation(source.getEntityName(), source.getLong("id"), sink.getEntityName(), sink.getLong("id"), associationType);
    }

    @Override
    public List<Long> getSinkIdsFromSource(GenericValue source, String sinkEntityName, String associationType) throws DataAccessException {
        List<GenericValue> sinks = this.getAssociationsFromSource(source.getEntityName(), source.getLong("id"), sinkEntityName, associationType);
        if (sinks != null && !sinks.isEmpty()) {
            ArrayList<Long> sinkIds = new ArrayList<Long>();
            for (GenericValue sink : sinks) {
                sinkIds.add(sink.getLong("sinkNodeId"));
            }
            return sinkIds;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getSourceIdsFromSink(GenericValue sink, String sourceEntity, String associationType) throws DataAccessException {
        List<GenericValue> associations = this.getAssociationsFromSink(sink, associationType, sourceEntity);
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        if (associations == null) {
            return sourceIds;
        }
        for (GenericValue gvAssoc : associations) {
            sourceIds.add(gvAssoc.getLong("sourceNodeId"));
        }
        return sourceIds;
    }

    private List<GenericValue> getAssociationsFromSource(String sourceEntityName, Long sourceNodeId, String sinkEntityName, String associationType) {
        FieldMap fieldMap = new FieldMap();
        fieldMap.put((Object)"sourceNodeEntity", (Object)sourceEntityName);
        fieldMap.put((Object)"sourceNodeId", (Object)sourceNodeId);
        fieldMap.put((Object)"sinkNodeEntity", (Object)sinkEntityName);
        fieldMap.put((Object)"associationType", (Object)associationType);
        return this.getAssociations("NodeAssociation", (Map<String, Object>)fieldMap, false);
    }

    private List<GenericValue> getAssociationsFromSink(GenericValue sink, String associationType, String sourceName) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sinkNodeId", sink.getLong("id"));
        fields.put("sinkNodeEntity", sink.getEntityName());
        fields.put("associationType", associationType);
        fields.put("sourceNodeEntity", sourceName);
        return this.getAssociations("NodeAssociation", fields, false);
    }

    private List<GenericValue> getAssociations(String associationName, Map<String, Object> fields, boolean useSequence) throws DataAccessException {
        List result = this.ofBizDelegator.findByAnd(associationName, fields);
        if (useSequence) {
            result = EntityUtil.orderBy((List)result, (List)UtilMisc.toList((Object)"sequence"));
        }
        return result;
    }

    private GenericValue getAssociation(String sourceNodeEntity, Long sourceNodeId, String sinkNodeEntity, Long sinkNodeId, String associationType) {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("NodeAssociation", UtilMisc.toMap((String)"associationType", (Object)associationType, (String)"sourceNodeId", (Object)sourceNodeId, (String)"sourceNodeEntity", (Object)sourceNodeEntity, (String)"sinkNodeId", (Object)sinkNodeId, (String)"sinkNodeEntity", (Object)sinkNodeEntity)));
    }
}

