/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import org.apache.log4j.Logger;

public class MinimumUpgradableVersionCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(MinimumUpgradableVersionCheck.class);
    private static final String NAME = "JIRA Minimum Upgradable Version Check";
    private static final String INSTRUCTIONS_URL = ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.upgrade.guide.for.old.versions");
    private final BuildUtilsInfo buildUtilsInfo = new BuildUtilsInfoImpl();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        if (this.databaseSetup()) {
            log.debug((Object)"Performing version check");
            int databaseBuildVersionNumber = this.getDbBuildNumber();
            if (databaseBuildVersionNumber > 0 && databaseBuildVersionNumber < this.getMinimumUpgradableBuildNumber()) {
                log.debug((Object)String.format("Your data is too old to be upgraded. Minimum version required: %d, your version: %d", this.getMinimumUpgradableBuildNumber(), databaseBuildVersionNumber));
                return false;
            }
        }
        return true;
    }

    private boolean databaseSetup() {
        return UpgradeUtils.tableExists("project");
    }

    @Override
    public String getHTMLFaultDescription() {
        StringBuffer message = new StringBuffer(512);
        message.append("<p>Failed to start due to your data being too old to be able to be upgraded by this version of JIRA.</p>");
        message.append("<p>Database version is: ").append(this.getDbBuildNumber()).append("</p>");
        message.append("<p>Minimum version required is: ").append(this.getMinimumUpgradableVersionString()).append("</p>");
        message.append("<p>You are running: ").append(this.buildUtilsInfo.getBuildInformation()).append("</p>");
        message.append("<p>For information on how to upgrade your data, please see <a href=\"").append(INSTRUCTIONS_URL).append("\">our documentation</a>.</p>");
        return message.toString();
    }

    @Override
    public void stop() {
    }

    @Override
    public String getFaultDescription() {
        StringBuffer message = new StringBuffer(512);
        message.append("Failed to start due to your data being too old to be able to be upgraded by this version of JIRA.\n");
        message.append("Database version is: ").append(this.getDbBuildNumber()).append("\n");
        message.append("Minimum version required is: ").append(this.getMinimumUpgradableVersionString()).append("\n");
        message.append("You are running: ").append(this.buildUtilsInfo.getBuildInformation()).append("\n");
        message.append("For information on how to upgrade your data, please see our documentation: ").append(INSTRUCTIONS_URL).append("\n");
        return message.toString();
    }

    private int getDbBuildNumber() {
        return UpgradeUtils.getJIRABuildVersionNumber();
    }

    private int getMinimumUpgradableBuildNumber() {
        return Integer.parseInt(this.buildUtilsInfo.getMinimumUpgradableBuildNumber());
    }

    private String getMinimumUpgradableVersionString() {
        return String.format("%s-#%d", this.buildUtilsInfo.getMinimumUpgradableVersion(), this.getMinimumUpgradableBuildNumber());
    }

    public String toString() {
        return NAME;
    }
}

