/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.workflow.migration.WorkflowMigrationMappingKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowMigrationMapping {
    private final Map mappings;
    private Logger log = Logger.getLogger(this.getClass());
    private final Collection issuesIdsOnWrongWorkflow;

    public WorkflowMigrationMapping() {
        this.mappings = new HashMap();
        this.issuesIdsOnWrongWorkflow = new HashSet();
    }

    public void addMapping(GenericValue issueType, GenericValue oldStatus, GenericValue newStatus) {
        WorkflowMigrationMappingKey mappingKey = new WorkflowMigrationMappingKey(issueType, oldStatus);
        this.log.debug((Object)("Adding (type, oldstatus) -> newstatus mapping: " + mappingKey + " -> " + newStatus.getString("name")));
        this.mappings.put(mappingKey, newStatus);
    }

    public void addIssueIdsOnWorongWorkflow(Collection issueIds) {
        this.issuesIdsOnWrongWorkflow.addAll(issueIds);
    }

    public boolean isIssueOnWrongWorkflow(Long issueId) {
        return this.issuesIdsOnWrongWorkflow.contains(issueId);
    }

    private GenericValue getTargetStatus(String issueTypeId, String oldStatusId) {
        WorkflowMigrationMappingKey mappingKey = new WorkflowMigrationMappingKey(issueTypeId, oldStatusId);
        GenericValue status = (GenericValue)this.mappings.get(mappingKey);
        if (status == null) {
            throw new RuntimeException("Encountered an issue whose status is not allowed in the existing workflow. No mapping from (type, status) = " + mappingKey + " defined.");
        }
        return status;
    }

    public GenericValue getTargetStatus(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("The entity passed must be of type issue, not '" + issue.getEntityName() + "'.");
        }
        return this.getTargetStatus(issue.getString("type"), issue.getString("status"));
    }
}

