/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.ErrorCollection;
import java.util.List;

public class WebActionUtil {
    public static void addDependentVersionErrors(ErrorCollection action, List versionIds, String fieldname) {
        WebActionUtil.addDependentEntityInvalidErrors(action, versionIds, fieldname, "You cannot specify \"Unreleased\" or \"Released\".");
        WebActionUtil.addDependentEntityUnknownErrors(action, versionIds, fieldname, "You cannot specify \"Unknown\" with a specific version.");
    }

    public static void addDependentComponentErrors(ErrorCollection errorCollection, List componentIds, String fieldname) {
        WebActionUtil.addDependentEntityUnknownErrors(errorCollection, componentIds, fieldname, "You cannot select \"Unknown\" with a specific component.");
    }

    public static void addDependentEntityInvalidErrors(ErrorCollection errorCollection, List entityIds, String fieldname, String errorMessage) {
        for (Long l : entityIds) {
            if (l >= -1L) continue;
            errorCollection.addError(fieldname, errorMessage);
        }
    }

    public static void addDependentEntityUnknownErrors(ErrorCollection errorCollection, List entityIds, String fieldname, String errorMessage) {
        if (entityIds.size() > 1) {
            for (Long l : entityIds) {
                if (l != -1L) continue;
                errorCollection.addError(fieldname, errorMessage);
            }
        }
    }
}

