/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util.portal;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public class PortalPageRetriever {
    private final PortalPageService portalPageService;
    private final Long sessionPageId;
    private Long requestedPageId = null;
    private PortalPage portalPage = null;
    private boolean doneLookup = false;

    public PortalPageRetriever(PortalPageService portalPageService, UserHistoryManager userHistoryManager, JiraAuthenticationContext authenticationContext, Long requestedPageId) {
        Assertions.notNull((String)"portalPageService", (Object)portalPageService);
        List history = userHistoryManager.getHistory(UserHistoryItem.DASHBOARD, authenticationContext.getLoggedInUser());
        this.sessionPageId = history.isEmpty() ? null : Long.valueOf(((UserHistoryItem)history.get(0)).getEntityId());
        this.portalPageService = portalPageService;
        this.requestedPageId = requestedPageId;
    }

    public PortalPageRetriever(PortalPageService portalPageService, UserHistoryManager userHistoryManager, JiraAuthenticationContext authenticationContext) {
        this(portalPageService, userHistoryManager, authenticationContext, null);
    }

    public Long getPageId() {
        if (this.requestedPageId != null) {
            return this.requestedPageId;
        }
        return this.sessionPageId;
    }

    public Long getRequestedPageId() {
        return this.requestedPageId;
    }

    public void setRequestedPageId(Long requestedPageId) {
        this.doneLookup = false;
        this.portalPage = null;
        this.requestedPageId = requestedPageId;
    }

    public PortalPage getPortalPage(JiraServiceContext ctx) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        if (!this.doneLookup) {
            this.doneLookup = true;
            Long pageId = this.getPageId();
            if (pageId != null) {
                this.portalPage = this.portalPageService.getPortalPage(ctx, pageId);
            } else {
                this.portalPage = null;
                ctx.getErrorCollection().addErrorMessage("dashboard.no.id.specified");
            }
        }
        return this.portalPage;
    }
}

