/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

public class ShowConstantsHelp
extends JiraWebActionSupport {
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final PermissionManager permissionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public ShowConstantsHelp(ConstantsManager constantsManager, SubTaskManager subTaskManager, PermissionManager permissionManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.permissionManager = permissionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    protected String doExecute() throws Exception {
        if (!this.permissionManager.hasProjects(10, this.getLoggedInUser())) {
            return "error";
        }
        return super.doExecute();
    }

    public boolean isSubTasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public Collection getIssueTypes() {
        return this.constantsManager.getIssueTypes();
    }

    public IssueType getIssueType(String id) {
        return this.constantsManager.getIssueTypeObject(id);
    }

    public Collection getSubTaskIssueTypes() {
        if (!this.isSubTasksEnabled()) {
            throw new IllegalStateException("Should not call this method as subtasks are disabled");
        }
        return this.constantsManager.getSubTaskIssueTypes();
    }

    public Collection getPriorities() {
        return this.constantsManager.getPriorityObjects();
    }

    public Collection getStatuses() {
        return this.constantsManager.getStatusObjects();
    }

    public Collection getResolutions() {
        return this.constantsManager.getResolutionObjects();
    }

    public Collection getSecurityLevels() {
        try {
            return this.issueSecurityLevelManager.getUsersSecurityLevels(this.getSelectedProject(), this.getLoggedInUser());
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Could not get user security levels for project", (Throwable)e);
            return null;
        }
    }
}

