/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.project.ViewProject;
import java.net.URI;

public class EditProjectLeadAndDefaultAssignee
extends ViewProject {
    private final ProjectService projectService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final UserPickerSearchService userPickerSearchService;
    private String leadError;
    private User leadUserObj;

    public EditProjectLeadAndDefaultAssignee(ProjectService projectService, AvatarService avatarService, UserManager userManager, UserPickerSearchService userPickerSearchService) {
        this.projectService = projectService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.userPickerSearchService = userPickerSearchService;
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getProject() == null) {
            return this.handleProjectDoesNotExist();
        }
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        this.setName(this.getProject().getString("name"));
        this.setAvatarId(this.getProject().getLong("avatar"));
        this.setLead(this.getProject().getString("lead"));
        this.setUrl(this.getProject().getString("url"));
        this.setDescription(this.getProject().getString("description"));
        this.setAssigneeType(this.getProject().getLong("assigneetype"));
        return "input";
    }

    private String handleProjectDoesNotExist() throws Exception {
        if (this.hasAdminPermission()) {
            this.setName("???");
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return super.doDefault();
        }
        return "securitybreach";
    }

    @Override
    protected void doValidation() {
        if (this.getProject() == null) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return;
        }
        Project projectObject = this.getProjectObject();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(this.getLoggedInUser(), projectObject.getName(), projectObject.getKey(), projectObject.getDescription(), this.getLead(), projectObject.getUrl(), this.getAssigneeType(), this.getAvatarId());
        if (!result.isValid()) {
            this.mapErrorCollection(result.getErrorCollection());
        }
        if (this.getLeadUserObj() == null) {
            this.setLeadError(this.getLead());
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        Project projectObject = this.getProjectObject();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(this.getLoggedInUser(), projectObject.getName(), projectObject.getKey(), projectObject.getDescription(), this.getLead(), projectObject.getUrl(), this.getAssigneeType(), this.getAvatarId());
        this.projectService.updateProject(result);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/people");
    }

    public boolean userPickerDisabled() {
        return !this.userPickerSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public User getLeadUserObj() {
        if (this.getLead() != null && this.leadUserObj == null) {
            this.leadUserObj = this.userManager.getUserObject(this.getLead());
        }
        return this.leadUserObj;
    }

    public URI getLeadUserAvatarUrl() {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), this.getLead(), Avatar.Size.SMALL);
    }

    public String getLeadError() {
        return this.leadError;
    }

    public void setLeadError(String leadError) {
        this.leadError = leadError;
    }
}

