/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.CreateIssueDetails;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.util.SubTaskQuickCreationConfig;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CreateSubTaskIssueDetails
extends CreateIssueDetails {
    public static final String SUB_TASK_LINK_TYPE_NAME = "jira_subtask_link";
    public static final String SUB_TASK_LINK_TYPE_STYLE = "jira_subtask";
    public static final String SUB_TASK_LINK_TYPE_INWARD_NAME = "jira_subtask_inward";
    public static final String SUB_TASK_LINK_TYPE_OUTWARD_NAME = "jira_subtask_outward";
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final SubTaskQuickCreationConfig subTaskQuickCreationConfig;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueService issueService;
    private Long parentIssueId;
    private boolean quickCreate;
    private boolean quickCreateValidation;
    private boolean fieldErrorsPresent;
    private boolean requiresLogin;
    private Collection providedFields;
    private FieldScreenRenderer quickCreationFieldScreenRenderer;

    public CreateSubTaskIssueDetails(ConstantsManager constantsManager, SubTaskManager subTaskManager, IssueCreationHelperBean issueCreationHelperBean, SubTaskQuickCreationConfig subTaskQuickCreationConfig, FieldScreenRendererFactory fieldScreenRendererFactory, IssueFactory issueFactory, IssueService issueService) {
        super(issueFactory, issueCreationHelperBean, issueService);
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.subTaskQuickCreationConfig = subTaskQuickCreationConfig;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueService = issueService;
        this.getIgnoreFieldIds().add("security");
        this.quickCreateValidation = false;
    }

    @Override
    protected void doValidation() {
        Long parentIssueId = this.getParentIssueId();
        if (parentIssueId == null) {
            this.addErrorMessage(this.getText("admin.errors.issues.parent.issue.id.not.set"));
            return;
        }
        MutableIssue parent = this.getIssueManager().getIssueObject(parentIssueId);
        if (parent != null && !parent.isEditable()) {
            this.addErrorMessage(this.getText("admin.errors.issues.parent.issue.not.editable"));
        }
        this.getIssueObject().setParentId(this.getParentIssueId());
        this.getIssueObject().setProject(this.getProject());
        this.getIssueObject().setIssueTypeId(this.getIssuetype());
        if (this.isQuickCreate()) {
            if (this.hasMandatoryFields()) {
                this.populateFieldHolderWithDefaults((Issue)this.getIssueObject(), this.getProvidedFields());
                for (String fieldId : this.getProvidedFields()) {
                    OrderableField field = (OrderableField)this.getField(fieldId);
                    field.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
                }
                this.fieldErrorsPresent = true;
                return;
            }
            this.quickCreateValidation = true;
            IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
            issueInputParameters.setProvidedFields(this.getProvidedFields());
            this.validationResult = this.issueService.validateSubTaskCreate(this.getLoggedInUser(), this.getParentIssueId(), issueInputParameters);
            if (!this.validationResult.isValid()) {
                ErrorCollection errorCollection = this.validationResult.getErrorCollection();
                this.transferErrorToMessages(errorCollection);
                this.addErrorCollection(errorCollection);
            }
            this.fieldValuesHolder = this.validationResult.getFieldValuesHolder();
            this.setIssueObject(this.validationResult.getIssue());
            if (this.invalidInput()) {
                this.quickCreateValidation = false;
            }
        } else {
            IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
            this.validationResult = this.issueService.validateSubTaskCreate(this.getLoggedInUser(), this.getParentIssueId(), issueInputParameters);
            if (!this.validationResult.isValid()) {
                ErrorCollection errorCollection = this.validationResult.getErrorCollection();
                this.transferErrorToMessages(errorCollection);
                this.addErrorCollection(errorCollection);
            }
            this.fieldValuesHolder = this.validationResult.getFieldValuesHolder();
            this.setIssueObject(this.validationResult.getIssue());
        }
        if (this.getReasons() != null && this.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            this.requiresLogin = true;
        }
    }

    @Override
    protected FieldScreenRenderer getFieldScreenRenderer() {
        if (this.quickCreateValidation) {
            if (this.quickCreationFieldScreenRenderer == null) {
                this.quickCreationFieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(new ArrayList(this.getProvidedFields()), this.getLoggedInUser(), (Issue)this.getIssueObject(), this.getIssueOperation());
            }
            return this.quickCreationFieldScreenRenderer;
        }
        return super.getFieldScreenRenderer();
    }

    protected boolean hasMandatoryFields() {
        Collection providedFields = this.getProvidedFields();
        Collection requiredFieldScreenRenderItems = this.getFieldScreenRenderer().getRequiredFieldScreenRenderItems();
        for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : requiredFieldScreenRenderItems) {
            OrderableField field = fieldScreenRenderLayoutItem.getOrderableField();
            if (providedFields.contains(field.getId())) continue;
            HashMap fieldValuesHolder = new HashMap();
            field.populateDefaults(fieldValuesHolder, (Issue)this.getIssueObject());
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            OperationContextImpl operationContext = new OperationContextImpl(this.getIssueOperation(), fieldValuesHolder);
            field.validateParams((OperationContext)operationContext, (ErrorCollection)errorCollection, (I18nHelper)this, (Issue)this.getIssueObject(), fieldScreenRenderLayoutItem);
            if (!errorCollection.hasAnyErrors()) continue;
            return true;
        }
        return false;
    }

    protected Collection getProvidedFields() {
        if (this.providedFields == null) {
            this.providedFields = this.subTaskQuickCreationConfig.getFieldIds();
        }
        return this.providedFields;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isFieldErrorsPresent()) {
            return "input";
        }
        return super.doExecute();
    }

    protected Collection getIssueTypes() {
        return this.constantsManager.getSubTaskIssueTypes();
    }

    @Override
    protected String doPostCreationTasks() throws Exception {
        if (this.invalidInput()) {
            return this.getResult();
        }
        this.createSubTaskLink();
        this.recordHistoryIssueType();
        if (TextUtils.stringSet((String)this.getViewIssueKey())) {
            MutableIssue viewIssue = this.getIssueManager().getIssueObject(this.getViewIssueKey());
            if (ManagerFactory.getPermissionManager().hasPermission(10, (Issue)viewIssue, this.getLoggedInUser())) {
                return this.getRedirect("/browse/" + this.getViewIssueKey() + "#summary");
            }
        }
        return super.doPostCreationTasks();
    }

    @Override
    protected void recordHistoryIssueType() {
        ActionContext.getSession().put("jira.user.history.subtask.issuetype", this.getIssuetype());
    }

    private void createSubTaskLink() throws GenericEntityException, CreateException {
        GenericValue parentIssue = this.getIssueManager().getIssue(this.getParentIssueId());
        this.subTaskManager.createSubTaskIssueLink(parentIssue, this.getIssue(), this.getLoggedInUser());
    }

    public String getParentIssueKey() {
        try {
            GenericValue parentIssue = this.getParentIssue();
            if (parentIssue != null) {
                return parentIssue.getString("key");
            }
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Error occurred while retrieving parent issue.", (Throwable)e);
            this.log.error((Object)"Error occurred while retrieving parent issue. Please see log for more detail.");
        }
        return null;
    }

    public String getParentIssuePath() {
        return "/browse/" + this.getParentIssueKey();
    }

    private GenericValue getParentIssue() throws GenericEntityException {
        return this.getIssueManager().getIssue(this.getParentIssueId());
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public void setParentIssueId(Long parentIssueId) {
        this.parentIssueId = parentIssueId;
    }

    public boolean isQuickCreate() {
        return this.quickCreate;
    }

    public boolean isFieldErrorsPresent() {
        return this.fieldErrorsPresent;
    }

    public void setQuickCreate(boolean quickCreate) {
        this.quickCreate = quickCreate;
    }

    public boolean isRequiresLogin() {
        return this.requiresLogin;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

