/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.action.issue.Assignable;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.action.issue.util.ScreenTabErrorHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CreateIssue
extends AbstractIssueSelectAction
implements Assignable,
OperationContext {
    protected final IssueCreationHelperBean issueCreationHelperBean;
    private final IssueFactory issueFactory;
    private Long pid;
    private String issuetype;
    protected Map fieldValuesHolder = new HashMap();
    private FieldScreenRenderer fieldScreenRenderer;
    private SortedSet tabsWithErrors;
    private int selectedTab = 1;
    private Collection ignoreFieldIds = EasyList.build((Object)"issuetype");

    public CreateIssue(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean) {
        this.issueFactory = issueFactory;
        this.issueCreationHelperBean = issueCreationHelperBean;
    }

    public String doDefault() throws Exception {
        this.issueCreationHelperBean.validateLicense((ErrorCollection)this, (I18nHelper)this);
        if (this.hasAnyErrors()) {
            return "invalidlicense";
        }
        GenericValue current = this.getSelectedProject();
        Long requestedPid = this.getPid();
        if (current != null && this.getAllowedProjects().contains(current)) {
            if (this.pid == null) {
                this.pid = current.getLong("id");
            }
            this.getFieldValuesHolder().put("project", this.pid);
        }
        String requestedIssueType = this.getIssuetype();
        this.setHistoryIssuetype();
        if (this.prepareFieldsIfOneOption(requestedPid, requestedIssueType)) {
            return this.getRedirectForCreateBypass();
        }
        return super.doDefault();
    }

    protected String getRedirectForCreateBypass() {
        return this.forceRedirect("CreateIssue.jspa?pid=" + this.getPid() + "&issuetype=" + this.getIssuetype());
    }

    protected void setHistoryIssuetype() {
        if (this.issuetype == null) {
            this.issuetype = (String)ActionContext.getSession().get("jira.user.history.issuetype");
        }
        if (this.issuetype == null) {
            this.issuetype = this.getApplicationProperties().getString("jira.constant.default.issue.type");
        }
        this.getFieldValuesHolder().put("issuetype", this.issuetype);
    }

    protected void doValidation() {
        try {
            this.issueCreationHelperBean.validateProject((Issue)this.getIssueObject(), (OperationContext)this, ActionContext.getParameters(), (ErrorCollection)this, (I18nHelper)this);
            if (!this.invalidInput()) {
                this.getIssueObject().setProject(this.getProject());
            }
            this.issueCreationHelperBean.validateIssueType((Issue)this.getIssueObject(), (OperationContext)this, ActionContext.getParameters(), (ErrorCollection)this, (I18nHelper)this);
            if (!this.invalidInput()) {
                this.getIssueObject().setIssueTypeId(this.getIssuetype());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage("An exception occurred: " + e + ".");
        }
    }

    protected void validateIssueType() {
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
        issueTypeField.validateParams(this, (ErrorCollection)this, (I18nHelper)this, (Issue)this.getIssueObject(), this.getFieldScreenRenderer().getFieldScreenRenderLayoutItem((OrderableField)issueTypeField));
    }

    protected String doExecute() throws Exception {
        this.issueCreationHelperBean.validateLicense((ErrorCollection)this, (I18nHelper)this);
        if (this.hasAnyErrors()) {
            return "invalidlicense";
        }
        ProjectSystemField projectField = (ProjectSystemField)this.getField("project");
        projectField.updateIssue(null, this.getIssueObject(), this.getFieldValuesHolder());
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.updateIssue(null, this.getIssueObject(), this.getFieldValuesHolder());
        this.recordHistoryIssueType();
        this.setSelectedProjectId(this.getPid());
        this.populateFieldHolderWithDefaults((Issue)this.getIssueObject(), Collections.EMPTY_LIST);
        return "success";
    }

    @Override
    public MutableIssue getIssueObject() {
        if (this.getIssueObjectWithoutDatabaseRead() == null) {
            this.setIssueObject(this.issueFactory.getIssue());
            this.getIssueObject().setProject(this.getProject());
            this.getIssueObject().setIssueTypeId(this.getIssuetype());
        }
        return this.getIssueObjectWithoutDatabaseRead();
    }

    protected void recordHistoryIssueType() {
        ActionContext.getSession().put("jira.user.history.issuetype", this.issuetype);
    }

    public Collection getAllowedProjects() {
        return this.getPermissionManager().getProjects(11, this.getLoggedInUser());
    }

    public boolean isAbleToCreateIssueInSelectedProject() {
        return this.getAllowedProjects().contains(this.getProject());
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Override
    public GenericValue getProject() {
        return this.getProjectManager().getProject(this.getPid());
    }

    public String getIssuetype() {
        return this.issuetype;
    }

    public void setIssuetype(String issueType) {
        this.issuetype = issueType;
    }

    public GenericValue getIssueTypeGV() {
        return ManagerFactory.getConstantsManager().getIssueType(this.getIssuetype());
    }

    @Override
    public String getAssignee() {
        return null;
    }

    @Override
    public void setAssignee(String assignee) {
    }

    public List getFieldScreenRenderTabs() {
        return this.getFieldScreenRenderer().getFieldScreenRenderTabs();
    }

    protected FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.issueCreationHelperBean.createFieldScreenRenderer(this.getLoggedInUser(), (Issue)this.getIssueObject());
        }
        return this.fieldScreenRenderer;
    }

    @Override
    public GenericValue getAssignIn() throws Exception {
        return this.getProject();
    }

    protected void populateFieldHolderWithDefaults(Issue issue, Collection excludedFieldIds) {
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderTabLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                String fieldId = fieldScreenRenderTabLayoutItem.getOrderableField().getId();
                if (excludedFieldIds.contains(fieldId) || "project".equals(fieldId) || "issuetype".equals(fieldId)) continue;
                fieldScreenRenderTabLayoutItem.populateDefaults(this.getFieldValuesHolder(), issue);
            }
        }
    }

    public List getCustomFields(Issue issue) {
        return this.getCustomFieldManager().getCustomFieldObjects(issue.getProject().getLong("id"), issue.getIssueTypeObject().getId());
    }

    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.CREATE_ISSUE_OPERATION;
    }

    public List getButtons() throws WorkflowException {
        ArrayList<ButtonHolder> buttons = new ArrayList<ButtonHolder>();
        Map buttonAttrs = this.getWorkflowMetaAttributes();
        for (String key : buttonAttrs.keySet()) {
            String val = (String)buttonAttrs.get(key);
            buttons.add(new ButtonHolder(key, this.getText(val)));
        }
        return buttons;
    }

    private final Map getWorkflowMetaAttributes() throws WorkflowException {
        JiraWorkflow workflow = ManagerFactory.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
        return workflow.getDescriptor().getInitialAction(1).getMetaAttributes();
    }

    public boolean isHasProjectPermission(int permissionsId, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("isHasProjectPermission can not be passed a null project");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("isHasProjectPermission can only take a Project: " + project.getEntityName() + " is not.");
        }
        return this.getPermissionManager().hasPermission(permissionsId, project, this.getLoggedInUser(), true);
    }

    public Collection getTabsWithErrors() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.tabsWithErrors;
    }

    private void initTabsWithErrors() {
        this.tabsWithErrors = new TreeSet();
        this.selectedTab = new ScreenTabErrorHelper().initialiseTabsWithErrors(this.tabsWithErrors, this.getErrors(), this.getFieldScreenRenderer(), ActionContext.getParameters());
    }

    public int getSelectedTab() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.selectedTab;
    }

    public Collection getIgnoreFieldIds() {
        return this.ignoreFieldIds;
    }

    public String getSubmitButtonName() {
        try {
            JiraWorkflow workflow = ManagerFactory.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
            return super.getWorkflowTransitionDisplayName(workflow.getDescriptor().getInitialAction(1));
        }
        catch (WorkflowException e) {
            this.log.error((Object)e, (Throwable)e);
            return "Create";
        }
    }

    private boolean hasProjectIdRequestParamSet() {
        try {
            return new Long(this.request.getParameter("pid")) != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    boolean prepareFieldsIfOneOption(Long requestedPid, String requestedIssueTypeId) {
        Project project;
        Long projectId = requestedPid;
        if (projectId == null) {
            Collection projects = this.getAllowedProjects();
            if (projects.size() != 1) {
                return false;
            }
            projectId = ((GenericValue)projects.iterator().next()).getLong("id");
        }
        if ((project = this.projectManager.getProjectObj(projectId)) != null) {
            Collection issueTypes = this.getIssueTypesForProject(project);
            if (requestedIssueTypeId == null) {
                if (issueTypes.size() == 1) {
                    IssueType issueType = (IssueType)issueTypes.iterator().next();
                    this.setPid(project.getId());
                    this.setIssuetype(issueType.getId());
                    return true;
                }
            } else {
                for (IssueType issueType : issueTypes) {
                    if (!issueType.getId().equals(requestedIssueTypeId)) continue;
                    this.setPid(project.getId());
                    this.setIssuetype(requestedIssueTypeId);
                    return true;
                }
            }
        }
        return false;
    }

    protected Collection getIssueTypesForProject(Project project) {
        IssueTypeSchemeManager issueTypeSchemeManager = ComponentAccessor.getIssueTypeSchemeManager();
        return issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project);
    }

    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public static class ButtonHolder {
        private final String name;
        private final String value;

        public ButtonHolder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

