/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowStep;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.net.URLEncoder;
import java.util.Collection;

@WebSudoRequired
public class DeleteWorkflowStep
extends AbstractWorkflowStep {
    private Collection destinationTransitions;
    final StepDescriptor step;
    private String originatingUrl;

    public DeleteWorkflowStep(JiraWorkflow workflow, StepDescriptor step, WorkflowService workflowService, ConstantsManager constantsManager) {
        super(workflow, constantsManager, workflowService);
        this.step = step;
    }

    protected void doValidation() {
        if (this.isOldStepOnDraft(this.step)) {
            this.addErrorMessage(this.getText("admin.errors.delete.step.draft"));
        }
        if (!this.workflow.isEditable()) {
            this.addErrorMessage(this.getText("admin.errors.delete.step.not.editable"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.workflow.removeStep(this.step);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getRedirect("ViewWorkflowSteps.jspa?workflowName=" + URLEncoder.encode(this.workflow.getName()) + "&workflowMode=" + this.getWorkflow().getMode());
    }

    public Collection getDestinationTransitions() {
        if (this.destinationTransitions == null) {
            this.destinationTransitions = this.workflow.getActionsWithResult(this.step);
        }
        return this.destinationTransitions;
    }

    @Override
    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public StepDescriptor getStep() {
        return this.step;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public void setOriginatingUrl(String originatingUrl) {
        this.originatingUrl = originatingUrl;
    }

    public String getCancelUrl() {
        if ("viewWorkflowStep".equals(this.getOriginatingUrl())) {
            return "ViewWorkflowStep.jspa?workflowStep=" + this.step.getId() + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowName=" + URLEncoder.encode(this.workflow.getName());
        }
        return "ViewWorkflowSteps.jspa?workflowName=" + URLEncoder.encode(this.workflow.getName()) + "&workflowMode=" + this.getWorkflow().getMode();
    }
}

