/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public abstract class AbstractViewWorkflowMetaAttributes
extends JiraWebActionSupport {
    private final JiraWorkflow workflow;
    private final WorkflowService workflowService;
    private Map metaAtrributes;
    private String attributeKey;
    private String attributeValue;

    protected AbstractViewWorkflowMetaAttributes(JiraWorkflow workflow, WorkflowService workflowService) {
        this.workflow = workflow;
        this.workflowService = workflowService;
    }

    protected void initializeAttributes() {
        this.metaAtrributes = new ListOrderedMap();
        for (Map.Entry entry : this.getEntityMetaAttributes().entrySet()) {
            String key = (String)entry.getKey();
            if (this.isReservedKey(key)) continue;
            this.metaAtrributes.put(key, entry.getValue());
        }
    }

    protected abstract Map getEntityMetaAttributes();

    protected boolean isReservedKey(String key) {
        if (key == null) {
            return false;
        }
        for (int i = 0; i < JiraWorkflow.JIRA_META_ATTRIBUTE_ALLOWED_LIST.length; ++i) {
            String allowedPrefix = JiraWorkflow.JIRA_META_ATTRIBUTE_ALLOWED_LIST[i];
            if (!key.equals(allowedPrefix) && !key.startsWith(allowedPrefix)) continue;
            return false;
        }
        return key.startsWith("jira.");
    }

    public Map getMetaAttributes() {
        return this.metaAtrributes;
    }

    @RequiresXsrfCheck
    public String doAddMetaAttribute() throws Exception {
        if (!TextUtils.stringSet((String)this.attributeKey)) {
            this.addError("attributeKey", this.getText("admin.errors.workflows.attribute.key.must.be.set"));
        } else if (this.isReservedKey(this.attributeKey)) {
            this.addError("attributeKey", this.getText("admin.errors.workflows.attribute.key.has.reserved.prefix", "'jira.'"));
        } else if (this.getEntityMetaAttributes().containsKey(this.attributeKey)) {
            this.addError("attributeKey", this.getText("admin.errors.workflows.attribute.key.exists", "'" + this.attributeKey + "'"));
        }
        WorkflowUtil.checkInvalidCharacters((String)this.attributeKey, (String)"attributeKey", (ErrorCollection)this);
        WorkflowUtil.checkInvalidCharacters((String)this.attributeValue, (String)"attributeValue", (ErrorCollection)this);
        if (this.invalidInput()) {
            return "input";
        }
        this.getEntityMetaAttributes().put(this.attributeKey, this.attributeValue);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getViewRidirect();
    }

    protected abstract String getViewRidirect() throws Exception;

    @RequiresXsrfCheck
    public String doRemoveMetaAttribute() throws Exception {
        if (!TextUtils.stringSet((String)this.attributeKey)) {
            this.addErrorMessage(this.getText("admin.errors.workflows.attribute.key.must.be.set"));
        } else if (!this.getEntityMetaAttributes().containsKey(this.attributeKey)) {
            this.addErrorMessage(this.getText("admin.errors.workflows.attribute.key.does.not.exist"));
        } else if (this.isReservedKey(this.attributeKey)) {
            this.addErrorMessage(this.getText("admin.errors.workflows.cannot.remove.reserved.attribute"));
        }
        if (this.invalidInput()) {
            return "input";
        }
        this.getEntityMetaAttributes().remove(this.attributeKey);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getViewRidirect();
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getWorkflowDisplayName() {
        return WorkflowUtil.getWorkflowDisplayName((JiraWorkflow)this.workflow);
    }

    public abstract String getRemoveAttributeUrl(String var1);
}

