/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class SelectProjectRepository
extends JiraWebActionSupport {
    private Long pid;
    private String[] repoIds;
    private List ids;
    private List repositories;
    private final RepositoryManager repositoryManager;

    public SelectProjectRepository(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public String doDefault() throws Exception {
        Collection<Repository> repositories = this.getRepositoryManager().getRepositoriesForProject(this.getProject());
        if (repositories != null) {
            this.repoIds = new String[repositories.size()];
            int i = 0;
            for (Repository repository : repositories) {
                this.repoIds[i] = repository.getId().toString();
                ++i;
            }
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (null == this.getProject()) {
            this.addErrorMessage(this.getText("admin.errors.repositories.must.specify.project"));
        }
        if (this.repoIds == null || this.repoIds.length == 0) {
            this.addError("repositoryIds", this.getText("admin.errors.repositories.please.select.repository"));
        } else {
            this.convertRepositoryIds();
            for (int i = 0; i < this.ids.size(); ++i) {
                Long id = (Long)this.ids.get(i);
                if (id >= 0L) continue;
                if (this.ids.size() > 1) {
                    this.addError(this.getRepositoryIdsControlName(), this.getText("admin.errors.repositories.cannot.select.none"));
                    break;
                }
                this.ids = Collections.EMPTY_LIST;
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getRepositoryManager().setProjectRepositories(this.getProject(), this.ids);
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/summary");
    }

    public GenericValue getProject() {
        return ManagerFactory.getProjectManager().getProject(this.getProjectId());
    }

    public Long getProjectId() {
        return this.pid;
    }

    public void setProjectId(Long pid) {
        this.pid = pid;
    }

    public void setRepositoryIds(String prids) {
        this.setRepoIds(new String[]{prids});
    }

    public String getRepositoryIds() {
        if (this.repoIds != null && this.repoIds.length > 0) {
            return this.repoIds[0];
        }
        return null;
    }

    protected void convertRepositoryIds() {
        if (this.ids == null) {
            this.ids = new ArrayList();
            for (int i = 0; i < this.repoIds.length; ++i) {
                String prid = this.repoIds[i];
                this.ids.add(new Long(prid));
            }
        }
    }

    public Collection getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>(this.getRepositoryManager().getRepositories());
            Collections.sort(this.repositories);
        }
        return this.repositories;
    }

    protected String[] getRepoIds() {
        return this.repoIds;
    }

    protected void setRepoIds(String[] repoIds) {
        this.repoIds = repoIds;
    }

    protected String getRepositoryIdsControlName() {
        return "repositoryIds";
    }

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }
}

