/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.ProjectIssueSecuritySchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditIssueSecurities
extends SchemeAwareIssueSecurityAction {
    private String name;
    private String description;
    private Long levelId;
    private final ProjectIssueSecuritySchemeHelper helper;
    private List<Project> projects;

    public EditIssueSecurities(ProjectIssueSecuritySchemeHelper helper) {
        this.helper = helper;
    }

    public Map getSchemeIssueSecurities() {
        IssueSecurityLevelManager secur = ManagerFactory.getIssueSecurityLevelManager();
        return JiraEntityUtils.createEntityMap(secur.getSchemeIssueSecurityLevels(this.getSchemeId()), "id", "name");
    }

    public List getSecurities(Long security) throws GenericEntityException {
        return ManagerFactory.getIssueSecuritySchemeManager().getEntities(this.getScheme(), security);
    }

    public String getIssueSecurityDescription(Long id) {
        IssueSecurityLevelManager secur = ManagerFactory.getIssueSecurityLevelManager();
        return secur.getIssueSecurityDescription(id);
    }

    public String doAddLevel() throws Exception {
        if (this.name == null || "".equals(this.name.trim())) {
            this.addError("name", this.getText("admin.errors.specify.name.for.security"));
        }
        if (CoreFactory.getGenericDelegator().findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)this.getSchemeId(), (Object)"name", (Object)this.name.trim())).size() > 0) {
            this.addError("name", this.getText("admin.errors.security.level.with.name.already.exists"));
        }
        if (this.getErrors().isEmpty()) {
            EntityUtils.createValue("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)this.getSchemeId(), (Object)"name", (Object)this.name, (Object)"description", (Object)this.description));
        }
        return this.getRedirect(this.getRedirectURL());
    }

    public String doMakeDefaultLevel() throws Exception {
        GenericValue scheme = this.getScheme();
        if (scheme != null) {
            if (new Long(-1L).equals(this.levelId)) {
                scheme.set("defaultlevel", null);
            } else {
                scheme.set("defaultlevel", (Object)this.levelId);
            }
            ManagerFactory.getIssueSecuritySchemeManager().updateScheme(scheme);
        }
        return this.getRedirect(this.getRedirectURL());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    @Override
    public String getRedirectURL() {
        return "EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId();
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme issueSecurityScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(issueSecurityScheme);
        }
        return this.projects;
    }
}

