/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens.enterprise;

import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ViewIssueTypeScreenSchemes
extends JiraWebActionSupport {
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private Collection issueTypeScreenSchemes;
    private Long id;
    private String schemeName;
    private String schemeDescription;
    private Long fieldScreenSchemeId;
    private boolean confirm;
    private IssueTypeScreenScheme issueTypeScreenScheme;
    private Collection fieldScreenSchemes;
    private Map projectsMap;

    public ViewIssueTypeScreenSchemes(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenSchemeManager fieldScreenSchemeManager) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.projectsMap = new HashMap();
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public Collection getIssueTypeScreenSchemes() {
        if (this.issueTypeScreenSchemes == null) {
            this.issueTypeScreenSchemes = this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes();
        }
        return this.issueTypeScreenSchemes;
    }

    @RequiresXsrfCheck
    public String doAddIssueTypeScreenScheme() {
        if (!TextUtils.stringSet((String)this.getSchemeName())) {
            this.addError("schemeName", this.getText("admin.common.errors.validname"));
        } else if (this.getFieldScreenSchemeId() == null) {
            this.addError("fieldScreenSchemeId", this.getText("admin.errors.screens.please.specify.a.screen.name"));
        } else {
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (!this.getSchemeName().equals(issueTypeScreenScheme.getName())) continue;
                this.addError("schemeName", this.getText("admin.errors.screens.duplicate.screen.scheme.name"));
            }
        }
        if (!this.invalidInput()) {
            IssueTypeScreenSchemeImpl issueTypeScreenScheme = new IssueTypeScreenSchemeImpl(this.issueTypeScreenSchemeManager, null);
            issueTypeScreenScheme.setName(this.getSchemeName());
            issueTypeScreenScheme.setDescription(this.getSchemeDescription());
            issueTypeScreenScheme.store();
            IssueTypeScreenSchemeEntityImpl issueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl(this.issueTypeScreenSchemeManager, (GenericValue)null, this.fieldScreenSchemeManager, this.getConstantsManager());
            issueTypeScreenSchemeEntity.setIssueTypeId(null);
            issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(this.getFieldScreenSchemeId()));
            issueTypeScreenScheme.addEntity(issueTypeScreenSchemeEntity);
            return this.redirectToView();
        }
        return this.getResult();
    }

    public Long getFieldScreenSchemeId() {
        return this.fieldScreenSchemeId;
    }

    public void setFieldScreenSchemeId(Long fieldScreenSchemeId) {
        this.fieldScreenSchemeId = fieldScreenSchemeId;
    }

    protected String redirectToView() {
        return this.getRedirect("ViewIssueTypeScreenSchemes.jspa");
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public void setSchemeDescription(String schemeDescription) {
        this.schemeDescription = schemeDescription;
    }

    public String doViewDeleteIssueTypeScreenScheme() {
        this.validateForDelete();
        if (!this.invalidInput()) {
            return "confirm";
        }
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doDeleteIssueTypeScreenScheme() {
        this.validateForDelete();
        if (!this.invalidInput()) {
            this.getIssueTypeScreenScheme().remove();
            return this.redirectToView();
        }
        return this.getResult();
    }

    private void validateForDelete() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else if (this.getIssueTypeScreenScheme() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.id2"));
        } else if (this.getIssueTypeScreenScheme().isDefault()) {
            this.addErrorMessage(this.getText("admin.errors.issuetypescreenschemes.cannot.delete.default"));
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        if (this.issueTypeScreenScheme == null) {
            this.issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getId());
        }
        return this.issueTypeScreenScheme;
    }

    public Collection getFieldScreenSchemes() {
        if (this.fieldScreenSchemes == null) {
            this.fieldScreenSchemes = this.fieldScreenSchemeManager.getFieldScreenSchemes();
        }
        return this.fieldScreenSchemes;
    }

    public Collection getProjects(IssueTypeScreenScheme issueTypeScreenScheme) {
        if (!this.projectsMap.containsKey(issueTypeScreenScheme.getId())) {
            this.projectsMap.put(issueTypeScreenScheme.getId(), issueTypeScreenScheme.getProjects());
        }
        return (Collection)this.projectsMap.get(issueTypeScreenScheme.getId());
    }
}

