/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

abstract class AbstractAsyncIndexerCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private final JohnsonEventContainer eventCont;
    private final IndexLifecycleManager indexManager;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;

    public AbstractAsyncIndexerCommand(JohnsonEventContainer eventCont, IndexLifecycleManager indexManager, Logger log, I18nHelper i18nHelper) {
        Assertions.notNull((String)"indexManager", (Object)indexManager);
        Assertions.notNull((String)"log", (Object)log);
        Assertions.notNull((String)"i18nHelper", (Object)i18nHelper);
        this.eventCont = eventCont;
        this.indexManager = indexManager;
        this.log = log;
        this.i18nHelper = i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() {
        Event appEvent = new Event(EventType.get((String)"reindex"), "JIRA is currently being reindexed. Depending on how large the database is, this may take a few minutes. Jira will automatically become available as soon as this task is complete.", EventLevel.get((String)"warning"));
        if (this.eventCont != null) {
            this.eventCont.addEvent(appEvent);
        }
        try {
            Context context = Contexts.percentageReporter((Sized)this.indexManager, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (Event)appEvent);
            this.log.info((Object)"Re-indexing started");
            IndexCommandResult indexCommandResult = this.doReindex(context, this.indexManager);
            return indexCommandResult;
        }
        finally {
            if (this.eventCont != null) {
                this.eventCont.removeEvent(appEvent);
            }
            this.log.info((Object)"Re-indexing finished");
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public abstract IndexCommandResult doReindex(Context var1, IndexLifecycleManager var2);
}

