/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatModuleDescriptors;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatTypes;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class ViewLookAndFeel
extends ProjectActionSupport {
    LookAndFeelBean lookAndFeelBean = null;
    private final UserFormatManager userFormatManager;
    private final UserFormatTypeConfiguration userFormatTypeConfiguration;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final UserFormatModuleDescriptors userFormatModuleDescriptors;
    private final UserFormatTypes userFormatTypes;

    public ViewLookAndFeel(UserFormatManager userFormatManager, UserFormatTypeConfiguration userFormatTypeConfiguration, I18nHelper.BeanFactory i18nBeanFactory, UserFormatModuleDescriptors userFormatModuleDescriptors, UserFormatTypes userFormatTypes) {
        this.userFormatManager = userFormatManager;
        this.userFormatTypeConfiguration = userFormatTypeConfiguration;
        this.i18nBeanFactory = i18nBeanFactory;
        this.userFormatModuleDescriptors = userFormatModuleDescriptors;
        this.userFormatTypes = userFormatTypes;
    }

    public Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public LookAndFeelBean getLookAndFeelBean() {
        if (this.lookAndFeelBean == null) {
            this.lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        }
        return this.lookAndFeelBean;
    }

    public boolean isShowInvisibleWarningForTopText() {
        LookAndFeelBean lookAndFeelBean = this.getLookAndFeelBean();
        String topBgColour = lookAndFeelBean.getTopBackgroundColour();
        String topTextColour = lookAndFeelBean.getTopTxtColour();
        if (topBgColour == null && topTextColour == null) {
            return false;
        }
        return topBgColour != null && topBgColour.equalsIgnoreCase(topTextColour);
    }

    public String getColor(String landFKeyName) {
        ApplicationProperties ap = this.getApplicationProperties();
        String colorValue = ap.getString(landFKeyName);
        String defaultColorValue = ap.getDefaultString(landFKeyName);
        String colorStr = colorValue;
        if (colorValue == null || StringUtils.equals((String)colorValue, (String)defaultColorValue)) {
            colorStr = "<" + this.getText("common.words.default") + ">";
            colorValue = ap.getDefaultBackedString(landFKeyName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"0\" cellspacing=\"0\"><tr>").append("<td><table cellspacing=\"1\" cellpadding=\"0\" border=\"1\"><tr><td><div style=\"width:18px;height:12px;font-size:0px;background-color:" + this.htmlEncode(colorValue) + ";\"></div></td></tr></table></td>").append("<td>&nbsp;").append(this.htmlEncode(colorStr)).append("</td>").append("</tr></table>");
        return sb.toString();
    }

    public List<Color> getGadgetColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (Color color : Color.values()) {
            if (color.equals((Object)Color.color8)) continue;
            colors.add(color);
        }
        return colors;
    }

    public String getGadgetColor(Color colorId) {
        return this.getColor("jira.lf.gadget." + colorId);
    }

    public String getUserFormatTypeDesc(String type) {
        UserFormatModuleDescriptor descriptor;
        if (StringUtils.isNotBlank((String)type) && (descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type))) != null) {
            String descriptionKey = descriptor.getDescriptionKey();
            if (StringUtils.isNotEmpty((String)descriptionKey)) {
                return this.getI18n().getText(descriptionKey);
            }
            return descriptor.getDescription();
        }
        return null;
    }

    public String getUserFormatTypeName(String type) {
        String typeKey;
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null && StringUtils.isNotEmpty((String)(typeKey = descriptor.getTypeI18nKey()))) {
            return this.getI18n().getText(typeKey);
        }
        return type;
    }

    public String getUserFormatName(String type) {
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null) {
            if (StringUtils.isNotEmpty((String)descriptor.getI18nNameKey())) {
                return this.getI18n().getText(descriptor.getI18nNameKey());
            }
            return descriptor.getName();
        }
        return "";
    }

    public Set<String> getUserFormatTypes() {
        return ImmutableSet.copyOf(this.userFormatTypes.get());
    }

    public String getSampleUserFormat(String type) {
        User remoteUser = this.getLoggedInUser();
        return this.userFormatManager.formatUser(Users.isAnonymous((User)remoteUser) ? null : remoteUser.getName(), type, "look_and_feel");
    }

    public boolean hasUserFormatsToEdit() {
        Set<String> types = this.getUserFormatTypes();
        for (String type : types) {
            if (Iterables.size(this.userFormatModuleDescriptors.forType(type)) <= 1) continue;
            return true;
        }
        return false;
    }

    private I18nHelper getI18n() {
        return this.i18nBeanFactory.getInstance(this.getLoggedInUser());
    }

    public boolean getUseISO8601() {
        return this.getApplicationProperties().getOption("jira.date.time.picker.use.iso8061");
    }

    public boolean isRefreshResourcesPerformed() {
        return this.request.getParameter("refreshResourcesPerformed") != null;
    }

    public String getLogoUrlWithContext() {
        return this.addContextToUrl(this.getLookAndFeelBean().getLogoUrl());
    }

    public String getFaviconHiResUrlWithContext() {
        return this.addContextToUrl(this.getLookAndFeelBean().getFaviconHiResUrl());
    }

    private String addContextToUrl(String url) {
        if (url != null && !url.startsWith("http://")) {
            String context = this.request.getContextPath();
            if ("/".equals(context)) {
                context = "";
            }
            url = context + url;
        }
        return url;
    }

    public String getLogoWidth() {
        return this.getLookAndFeelBean().getLogoWidth();
    }

    public String getLogoHeight() {
        return this.getLookAndFeelBean().getLogoHeight();
    }

    public String getFaviconHiResWidth() {
        return this.getLookAndFeelBean().getFaviconHiResWidth();
    }

    public String getFaviconHiResHeight() {
        return this.getLookAndFeelBean().getFaviconHiResHeight();
    }
}

