/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.logging.MultiTenantJiraHomeAppender;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.util.json.JsonUtil;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.util.log.LogMarker;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@WebSudoRequired
public class ViewLogging
extends JiraWebActionSupport {
    private List<Logger> loggers;
    private Logger rootLogger;
    private String markMessage;
    private boolean rollOver;
    private static final Collection<Level> availableLevels = ImmutableList.of((Object)Level.DEBUG, (Object)Level.INFO, (Object)Level.WARN, (Object)Level.ERROR, (Object)Level.FATAL, (Object)Level.OFF);
    private static final String VIEW_LOGGING_JSPA = "ViewLogging.jspa";
    private static final String HASH_HTTP = "#http";
    private static final String HASH_SOAP = "#soap";
    private static final String HASH_SQL = "#sql";
    private static final String HASH_PROFILING = "#profiling";
    private static final String HASH_MAIL = "#mail";
    private static final String SOAP_ACCESS_LOG = "com.atlassian.jira.soap.axis.JiraAxisSoapLog";
    private static final String SOAP_DUMP_LOG = "com.atlassian.jira.soap.axis.JiraAxisSoapLogDump";
    private static final String HTTP_ACCESS_LOG = "com.atlassian.jira.web.filters.accesslog.AccessLogFilter";
    private static final String HTTP_DUMP_LOG = "com.atlassian.jira.web.filters.accesslog.AccessLogFilterDump";
    private static final String HTTP_ACCESS_LOG_INCLUDE_IMAGES = "com.atlassian.jira.web.filters.accesslog.AccessLogFilterIncludeImages";
    private static final String SQL_LOG = "com.atlassian.jira.ofbiz.LoggingSQLInterceptor";
    private static final Set<String> LOGGER_NAME_EXEMPTION_SET;
    private final MailServerManager mailServerManager;
    private final MailLoggingManager mailLoggingManager;

    public ViewLogging(MailServerManager mailServerManager, MailLoggingManager mailLoggingManager) {
        this.mailServerManager = mailServerManager;
        this.mailLoggingManager = mailLoggingManager;
    }

    public Collection getLoggers() {
        if (this.loggers == null) {
            this.loggers = new ArrayList<Logger>();
            Enumeration currentLoggers = LogManager.getCurrentLoggers();
            while (currentLoggers.hasMoreElements()) {
                Logger logger = (Logger)currentLoggers.nextElement();
                if (logger.getLevel() == null || LOGGER_NAME_EXEMPTION_SET.contains(logger.getName()) || this.mailLoggingManager.isMailRelatedLogger(logger)) continue;
                this.loggers.add(logger);
            }
            Collections.sort(this.loggers, new LoggerComparator());
        }
        return this.loggers;
    }

    public Logger getRootLogger() {
        if (this.rootLogger == null) {
            this.rootLogger = Logger.getRootLogger();
        }
        return this.rootLogger;
    }

    public Collection<Level> getAvailableLevels() {
        return availableLevels;
    }

    public String getAvailableLevelsAsJson() {
        return JsonUtil.toJsonString(Collections2.transform(this.getAvailableLevels(), (Function)new Function<Level, String>(){

            public String apply(Level from) {
                return from.toString();
            }
        }));
    }

    public String doMarkLogs() throws Exception {
        String msg = this.getMarkMessage();
        if (this.rollOver) {
            LogMarker.rolloverAndMark(msg);
        } else {
            LogMarker.markLogs(msg);
        }
        return this.getRedirect(VIEW_LOGGING_JSPA);
    }

    public String doEnableProfiling() throws Exception {
        System.setProperty("atlassian.profile.mintime", "1");
        UtilTimerStack.setActive((boolean)true);
        return this.getRedirect("ViewLogging.jspa#profiling");
    }

    public String doDisableProfiling() throws Exception {
        UtilTimerStack.setActive((boolean)false);
        return this.getRedirect("ViewLogging.jspa#profiling");
    }

    public boolean isProfilingEnabled() {
        return UtilTimerStack.isActive();
    }

    public String doEnableSoapAccessLog() {
        this.getSoapAccessLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#soap");
    }

    public String doDisableSoapAccessLog() {
        this.getSoapAccessLogger().setLevel(Level.OFF);
        this.getSoapDumpLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#soap");
    }

    public String doEnableSoapDumpLog() {
        this.getSoapDumpLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#soap");
    }

    public String doDisableSoapDumpLog() {
        this.getSoapDumpLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#soap");
    }

    private Logger getSoapAccessLogger() {
        return Logger.getLogger((String)SOAP_ACCESS_LOG);
    }

    private Logger getSoapDumpLogger() {
        return Logger.getLogger((String)SOAP_DUMP_LOG);
    }

    public boolean isSoapAccessLogEnabled() {
        return this.getSoapAccessLogger().getLevel() != Level.OFF;
    }

    public boolean isSoapDumpLogEnabled() {
        return this.getSoapDumpLogger().getLevel() != Level.OFF;
    }

    public String doEnableHttpAccessLog() {
        this.getHttpAccessLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    public String doDisableHttpAccessLog() {
        this.getHttpAccessLogger().setLevel(Level.OFF);
        this.getHttpAccessIncludeImagesLogger().setLevel(Level.OFF);
        this.getHttpDumpLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpAccessLogger() {
        return Logger.getLogger((String)HTTP_ACCESS_LOG);
    }

    public boolean isHttpAccessLogEnabled() {
        return this.getHttpAccessLogger().getLevel() != Level.OFF;
    }

    public String doEnableHttpDumpLog() {
        this.getHttpDumpLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    public String doDisableHttpDumpLog() {
        this.getHttpDumpLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpDumpLogger() {
        return Logger.getLogger((String)HTTP_DUMP_LOG);
    }

    public boolean isHttpDumpLogEnabled() {
        return this.getHttpDumpLogger().getLevel() != Level.OFF;
    }

    public String doEnableHttpAccessLogIncludeImages() {
        this.getHttpAccessIncludeImagesLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    public String doDisableHttpAccessLogIncludeImages() {
        this.getHttpAccessIncludeImagesLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#http");
    }

    private Logger getHttpAccessIncludeImagesLogger() {
        return Logger.getLogger((String)HTTP_ACCESS_LOG_INCLUDE_IMAGES);
    }

    public boolean isHttpAccessLogIncludeImagesEnabled() {
        return this.getHttpAccessIncludeImagesLogger().getLevel() != Level.OFF;
    }

    public String doEnableSqlLog() {
        this.getSqlLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    public String doDisableSqlLog() {
        this.getSqlLogger().setLevel(Level.OFF);
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    public String doEnableSqlDumpLog() {
        this.getSqlLogger().setLevel(Level.DEBUG);
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    public String doDisableSqlDumpLog() {
        this.getSqlLogger().setLevel(Level.INFO);
        return this.getRedirect("ViewLogging.jspa#sql");
    }

    private Logger getSqlLogger() {
        return Logger.getLogger((String)SQL_LOG);
    }

    public boolean isSqlLogEnabled() {
        return this.getSqlLogger().getLevel() != Level.OFF;
    }

    public boolean isSqlDumpLogEnabled() {
        return this.getSqlLogger().getLevel() == Level.DEBUG;
    }

    public boolean isAtLevel(Logger logger, String targetLevel) {
        String loggerLevelName = logger.getEffectiveLevel().toString();
        return targetLevel.equals(loggerLevelName);
    }

    public Logger getOutgoingMailLogger() {
        return Logger.getLogger((String)"com.atlassian.mail");
    }

    public boolean isOutgoingMailLoggingEnabled() {
        return this.mailLoggingManager.getOutgoingMailLoggingLevel() != Level.OFF;
    }

    public boolean isOutgoingMailDebugEnabled() {
        return this.mailLoggingManager.getOutgoingMailLoggingLevel() == Level.DEBUG;
    }

    public boolean isIncomingMailLoggingEnabled() {
        return this.mailLoggingManager.getIncomingMailLoggingLevel() != Level.OFF;
    }

    public boolean isIncomingMailDebugEnabled() {
        return this.mailLoggingManager.getIncomingMailLoggingLevel() == Level.DEBUG;
    }

    public boolean isOutgoingMailServerDefined() {
        return this.mailServerManager.getDefaultSMTPMailServer() != null;
    }

    public boolean isIncomingMailServerDefined() {
        return !this.mailServerManager.getPopMailServers().isEmpty();
    }

    @Nullable
    public String getOutgoingMailFirstLogFileName() {
        return StringUtils.defaultString((String)this.getFirstFileAppenderFileName(this.mailLoggingManager.getOutgoingMailLogger()), (String)"atlassian-jira-outgoing-mail.log");
    }

    @Nullable
    public String getIncomingMailFirstLogFileName() {
        return StringUtils.defaultString((String)this.getFirstFileAppenderFileName(this.mailLoggingManager.getIncomingMailLogger()), (String)"atlassian-jira-incoming-mail.log");
    }

    @Nullable
    public String getFirstFileAppenderFileName(Logger logger) {
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Appender fileAppender = (Appender)Iterables.get((Iterable)Iterables.filter(appenders, (Predicate)new Predicate<Appender>(){

            public boolean apply(Appender input) {
                if (input instanceof MultiTenantJiraHomeAppender) {
                    return ((MultiTenantJiraHomeAppender)input).getFile() != null;
                }
                return Log4jKit.getLogFileName(input.getName()) != null;
            }
        }), (int)0, null);
        if (fileAppender == null) {
            return null;
        }
        if (fileAppender instanceof MultiTenantJiraHomeAppender) {
            return FilenameUtils.getName((String)((MultiTenantJiraHomeAppender)fileAppender).getFile());
        }
        File file = Log4jKit.getLogFileName(fileAppender.getName());
        return file != null ? file.getName() : null;
    }

    public String doEnableOutgoingMailLogging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    public String doDisableOutgoingMailLogging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.OFF);
    }

    public String doDisableOutgoingMailDebugging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    public String doEnableOutgoingMailDebugging() {
        return this.setOutgoingMailLoggingLevelAndRedirectBack(Level.DEBUG);
    }

    public String doEnableIncomingMailLogging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    public String doDisableIncomingMailLogging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.OFF);
    }

    public String doDisableIncomingMailDebugging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.INFO);
    }

    public String doEnableIncomingMailDebugging() {
        return this.setIncomingMailLoggingLevelAndRedirectBack(Level.DEBUG);
    }

    private String setOutgoingMailLoggingLevelAndRedirectBack(Level loggingLevel) {
        this.mailLoggingManager.setOutgoingMailLoggingLevel(loggingLevel);
        return this.getRedirect("ViewLogging.jspa#mail");
    }

    private String setIncomingMailLoggingLevelAndRedirectBack(Level loggingLevel) {
        this.mailLoggingManager.setIncomingMailLoggingLevel(loggingLevel);
        return this.getRedirect("ViewLogging.jspa#mail");
    }

    public String getMarkMessage() {
        return this.markMessage;
    }

    public void setMarkMessage(String markMessage) {
        this.markMessage = markMessage;
    }

    public boolean isRollOver() {
        return this.rollOver;
    }

    public void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(SQL_LOG);
        set.add(SOAP_ACCESS_LOG);
        set.add(SOAP_DUMP_LOG);
        set.add(HTTP_ACCESS_LOG);
        set.add(HTTP_DUMP_LOG);
        set.add(HTTP_ACCESS_LOG_INCLUDE_IMAGES);
        LOGGER_NAME_EXEMPTION_SET = Collections.unmodifiableSet(set);
    }

    private static class LoggerComparator
    implements Comparator<Logger> {
        private LoggerComparator() {
        }

        @Override
        public int compare(Logger o1, Logger o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1 == null || name2 == null) {
                return 0;
            }
            return name1.compareTo(name2);
        }
    }
}

