/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ParameterAware;

@WebSudoRequired
public class EditListener
extends JiraWebActionSupport
implements ParameterAware {
    Long id;
    GenericValue listener;
    Map params;
    private final PluginAccessor pluginAccessor;
    private final ListenerManager listenerManager;

    public EditListener(PluginAccessor pluginAccessor, ListenerManager listenerManager) {
        this.pluginAccessor = pluginAccessor;
        this.listenerManager = listenerManager;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            PropertySet ps = OFBizPropertyUtils.getPropertySet(this.getListener());
            JiraListener listener = this.getJiraListener();
            for (int i = 0; i < listener.getAcceptedParams().length; ++i) {
                String paramName = listener.getAcceptedParams()[i];
                String paramValue = ((String[])this.params.get(paramName))[0];
                if (!TextUtils.stringSet((String)paramValue)) {
                    paramValue = null;
                }
                if (paramValue != null) {
                    ps.setString(paramName, paramValue);
                    continue;
                }
                if (!ps.exists(paramName)) continue;
                ps.remove(paramName);
            }
            this.listenerManager.refresh();
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred trying to update listener properties: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.updating.listener.properties") + " " + e);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("ViewListeners!default.jspa");
    }

    protected void doValidation() {
        if (this.getListener() == null) {
            this.addErrorMessage(this.getText("admin.errors.listener.does.not.exist"));
        }
        super.doValidation();
    }

    public String[] getAcceptedParams() {
        try {
            return this.getJiraListener().getAcceptedParams();
        }
        catch (Exception e) {
            this.log.error((Object)("Error getting accepted params: " + e.getMessage()), (Throwable)e);
            return new String[0];
        }
    }

    public JiraListener getJiraListener() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (JiraListener)ClassLoaderUtils.loadClass((String)this.getListener().getString("clazz"), (ClassLoader)this.pluginAccessor.getClassLoader()).newInstance();
    }

    public String getParamValue(String s) {
        PropertySet ps = OFBizPropertyUtils.getPropertySet(this.getListener());
        return ps.getString(s);
    }

    public GenericValue getListener() {
        if (this.listener == null) {
            try {
                this.listener = this.getOfBizDelegator().findByPrimaryKey("ListenerConfig", EasyMap.build((Object)"id", (Object)this.id));
            }
            catch (DataAccessException e) {
                this.log.error((Object)("Error getting ListenerConfig with id " + this.id), (Throwable)e);
            }
        }
        return this.listener;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParameters(Map map) {
        this.params = map;
    }
}

