/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.http.response;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ObservantResponseWrapper
extends HttpServletResponseWrapper {
    private long contentLen = 0L;
    private int status = 200;
    private SizeObservingPrintWriter sizeCapturingPrintWriter;
    private SizeObservingServletOutputStream sizeCapturingServletOutputStream;

    public ObservantResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public int getStatus() {
        return this.status;
    }

    public long getContentLen() {
        return this.contentLen;
    }

    public void sendError(int sc, String s) throws IOException {
        this.status = sc;
        super.sendError(sc, s);
    }

    public void sendError(int sc) throws IOException {
        this.status = sc;
        super.sendError(sc);
    }

    public void setStatus(int sc) {
        this.status = sc;
        super.setStatus(sc);
    }

    public void setStatus(int sc, String s) {
        this.status = sc;
        super.setStatus(sc, s);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.sizeCapturingPrintWriter == null) {
            this.sizeCapturingPrintWriter = new SizeObservingPrintWriter(super.getWriter());
        }
        return this.sizeCapturingPrintWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sizeCapturingServletOutputStream == null) {
            this.sizeCapturingServletOutputStream = new SizeObservingServletOutputStream(super.getOutputStream());
        }
        return this.sizeCapturingServletOutputStream;
    }

    private class SizeObservingServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegateStream;

        private SizeObservingServletOutputStream(ServletOutputStream delegateStream) {
            this.delegateStream = delegateStream;
        }

        public void write(int b) throws IOException {
            this.delegateStream.write(b);
            ObservantResponseWrapper.this.contentLen++;
        }

        public void write(byte[] b) throws IOException {
            this.delegateStream.write(b);
            ObservantResponseWrapper.this.contentLen += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegateStream.write(b, off, len);
            ObservantResponseWrapper.this.contentLen += len;
        }
    }

    private class SizeObservingPrintWriter
    extends PrintWriter {
        private SizeObservingPrintWriter(PrintWriter delegate) {
            super(delegate);
        }

        private int determineByteCount(char[] buf, int off, int len) {
            return len;
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            ObservantResponseWrapper.this.contentLen += this.determineByteCount(buf, off, len);
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            ObservantResponseWrapper.this.contentLen += this.determineByteCount(s.toCharArray(), off, len);
        }

        @Override
        public void println() {
            super.println();
            ObservantResponseWrapper.this.contentLen += 1L;
        }
    }
}

