/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.ExceptionInterpreter;
import com.atlassian.jira.util.OracleDataSizeExceptionInterpreter;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;

public class ExceptionInterpreterUtil {
    private static final ExceptionInterpreter interpreter = new OracleDataSizeExceptionInterpreter();

    public static void addInterpreter(ExceptionInterpreter val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add a null exception interpreter");
        }
        interpreter.append(val);
    }

    public static String execute(ExtendedSystemInfoUtils extendedSystemInfoUtils, String exceptionMessage) {
        String interpretedExceptionMessage = null;
        try {
            interpretedExceptionMessage = interpreter.invoke(extendedSystemInfoUtils, exceptionMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interpretedExceptionMessage;
    }
}

