/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.profile.AbstractUserProfileFragment;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;

public class PreferencesUserProfileFragment
extends AbstractUserProfileFragment {
    private final UserPreferencesManager preferencesManager;
    private final LocaleManager localeManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final TimeZoneService timeZoneManager;

    public PreferencesUserProfileFragment(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VelocityManager velocityManager, VelocityParamFactory velocityParamFactory, UserPreferencesManager preferencesManager, LocaleManager localeManager, I18nHelper.BeanFactory i18nCachingFactory, TimeZoneService timeZoneManager) {
        super(applicationProperties, jiraAuthenticationContext, velocityManager, velocityParamFactory);
        this.preferencesManager = preferencesManager;
        this.localeManager = localeManager;
        this.i18nFactory = i18nCachingFactory;
        this.timeZoneManager = timeZoneManager;
    }

    @Override
    protected Map<String, Object> createVelocityParams(User profileUser, User currentUser) {
        String localeName;
        Preferences preferences = this.preferencesManager.getPreferences(profileUser);
        String userLocale = preferences.getString("jira.user.locale");
        if (TextUtils.stringSet((String)userLocale)) {
            localeName = this.localeManager.getLocale(userLocale).getDisplayName(this.jiraAuthenticationContext.getLocale());
        } else {
            I18nHelper i18n = this.i18nFactory.getInstance(profileUser);
            localeName = i18n.getText("admin.common.phrases.default.locale", this.applicationProperties.getDefaultLocale().getDisplayName(this.jiraAuthenticationContext.getLocale()));
        }
        Map<String, Object> params = super.createVelocityParams(profileUser, currentUser);
        params.put("user", profileUser);
        params.put("localeName", localeName);
        final SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        JiraServiceContext serviceContext = new JiraServiceContext(){

            public ErrorCollection getErrorCollection() {
                return simpleErrorCollection;
            }

            public User getLoggedInUser() {
                return PreferencesUserProfileFragment.this.jiraAuthenticationContext.getLoggedInUser();
            }

            public I18nHelper getI18nBean() {
                return PreferencesUserProfileFragment.this.jiraAuthenticationContext.getI18nBean();
            }
        };
        params.put("usesJiraTimeZone", this.timeZoneManager.usesJiraTimeZone(serviceContext));
        params.put("timezone", this.timeZoneManager.getUserTimeZoneInfo(serviceContext));
        params.put("pageSize", preferences.getLong("user.issues.per.page"));
        String mimeType = preferences.getString("user.notifications.mimetype");
        if ("html".equals(mimeType)) {
            params.put("mimeType", "HTML");
        } else {
            params.put("mimeType", "Text");
        }
        params.put("notifyOwnChanges", preferences.getBoolean("user.notify.own.changes"));
        params.put("sharePrivate", preferences.getBoolean("user.default.share.private"));
        params.put("keyboardShortcutsEnabled", !preferences.getBoolean("user.keyboard.shortcuts.disabled"));
        return params;
    }

    @Override
    @SuppressWarnings(value={"NM_WRONG_PACKAGE"}, justification="OSUser is deprecated and dying anyway. Plus the method in question is final so we can't override it.")
    public boolean showFragment(User profileUser, User currentUser) {
        return profileUser.equals(currentUser);
    }

    @Override
    public String getId() {
        return "preferences-profile-fragment";
    }
}

