/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class DefaultUserPreferencesManager
implements UserPreferencesManager,
Startable {
    private Map cache;
    private final EventPublisher eventPublisher;

    public DefaultUserPreferencesManager(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.cache = Collections.synchronizedMap(new LRUMap(250));
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public Preferences getPreferences(User user) {
        if (user == null) {
            return new JiraUserPreferences((User)null);
        }
        Preferences prefs = (Preferences)this.cache.get(user.getName());
        if (prefs == null) {
            prefs = new JiraUserPreferences(user);
            this.cache.put(user.getName(), prefs);
        }
        return prefs;
    }

    public void clearCache(String username) {
        this.cache.remove(username);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

