/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class UpgradeTask_Build634
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build634.class);
    private final CustomFieldManager customFieldManager;

    public UpgradeTask_Build634(CustomFieldManager customFieldManager) {
        super(false);
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getBuildNumber() {
        return "634";
    }

    @Override
    public String getShortDescription() {
        return "Converting Custom field values for Select and MultiSelect types to store the id of the option rather than the value -  cleanup.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<CustomField> customFieldList = this.getCustomFields();
        Connection connection = this.getDatabaseConnection();
        try {
            connection.setAutoCommit(false);
            for (CustomField customField : customFieldList) {
                this.processCustomField(connection, customField);
            }
        }
        finally {
            connection.close();
        }
    }

    private void processCustomField(Connection connection, CustomField customField) throws GenericEntityException, SQLException {
        String sql = "update " + this.convertToSchemaTableName("customfieldvalue") + " set numbervalue = null" + " where customfield = " + customField.getGenericValue().getLong("id");
        Statement stmt = connection.createStatement();
        stmt.execute(sql);
        stmt.close();
        connection.commit();
    }

    private List<CustomField> getCustomFields() {
        ArrayList<CustomField> selectCustomFields = new ArrayList<CustomField>();
        List customFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFields) {
            CustomFieldType type = customField.getCustomFieldType();
            if (!(type instanceof SelectCFType) && !(type instanceof MultiSelectCFType)) continue;
            selectCustomFields.add(customField);
        }
        return selectCustomFields;
    }
}

