/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class SharePermissionUtils {
    private static final String TYPE_KEY = "type";
    private static final String PARAM1_KEY = "param1";
    private static final String PARAM2_KEY = "param2";

    public static JSONObject toJson(SharePermission permission) throws JSONException {
        Assertions.notNull((String)"permission", (Object)permission);
        JSONObject object = new JSONObject();
        object.put(TYPE_KEY, (Object)permission.getType());
        if (permission.getParam1() != null) {
            object.put(PARAM1_KEY, (Object)permission.getParam1());
            if (permission.getParam2() != null) {
                object.put(PARAM2_KEY, (Object)permission.getParam2());
            }
        }
        return object;
    }

    public static JSONArray toJsonArray(Collection<SharePermission> permissions) throws JSONException {
        Assertions.notNull((String)"permission", permissions);
        JSONArray array = new JSONArray();
        for (SharePermission sharePermission : permissions) {
            array.put((Object)SharePermissionUtils.toJson(sharePermission));
        }
        return array;
    }

    public static SharePermission fromJsonObject(JSONObject json) throws JSONException {
        ShareType.Name type;
        Assertions.notNull((String)"json", (Object)json);
        if (!json.has(TYPE_KEY)) {
            throw new JSONException("Invalid JSON SharePermission: No type passed.");
        }
        try {
            type = new ShareType.Name(json.getString(TYPE_KEY));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException((Throwable)e);
        }
        String param1 = null;
        String param2 = null;
        if (json.has(PARAM1_KEY)) {
            param1 = json.getString(PARAM1_KEY);
            if (StringUtils.isBlank((String)param1)) {
                throw new JSONException("Invalid JSON SharePermission: 'param1' cannot be blank.");
            }
            if (json.has(PARAM2_KEY) && StringUtils.isBlank((String)(param2 = json.getString(PARAM2_KEY)))) {
                throw new JSONException("Invalid JSON SharePermission: 'param2' cannot be blank.");
            }
        } else if (json.has(PARAM2_KEY)) {
            throw new JSONException("Invalid JSON SharePermission: 'param2' passed without 'param1'.");
        }
        return new SharePermissionImpl(type, param1, param2);
    }

    public static SharePermission fromJsonObjectString(String jsonString) throws JSONException {
        Assertions.notNull((String)"jsonString", (Object)jsonString);
        if (StringUtils.isBlank((String)jsonString)) {
            return null;
        }
        return SharePermissionUtils.fromJsonObject(new JSONObject(jsonString));
    }

    public static SharedEntity.SharePermissions fromJsonArray(JSONArray array) throws JSONException {
        Assertions.notNull((String)"array", (Object)array);
        HashSet<SharePermission> permissions = new HashSet<SharePermission>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            permissions.add(SharePermissionUtils.fromJsonObject(array.getJSONObject(i)));
        }
        return new SharedEntity.SharePermissions(permissions);
    }

    public static SharedEntity.SharePermissions fromJsonArrayString(String jsonString) throws JSONException {
        Assertions.notNull((String)"jsonString", (Object)jsonString);
        if (StringUtils.isBlank((String)jsonString)) {
            return SharedEntity.SharePermissions.PRIVATE;
        }
        return SharePermissionUtils.fromJsonArray(new JSONArray(jsonString));
    }

    private SharePermissionUtils() {
    }
}

