/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;
import org.slf4j.MDC;
import webwork.action.ActionContext;
import webwork.action.ActionSupport;

public class XsrfVulnerabilityDetectionSQLInterceptor
implements SQLConnectionInterceptor {
    private static final Logger log = Logger.getLogger(XsrfVulnerabilityDetectionSQLInterceptor.class);
    private static final String XSRF_VULNERABILITY_DETECTION_SQLINTERCEPTOR_DONE = "XsrfVulnerabilityDetectionSQLInterceptorDone";
    static final List<String> methodsToIgnore = CollectionBuilder.list((Object[])new String[]{"com.atlassian.sal.jira.lifecycle.JiraLifecycleManager.onJiraStart", "com.atlassian.jira.security.login.LoginStoreImpl.recordLoginAttempt", "com.atlassian.jira.user.DefaultUserHistoryManager.addItemToHistory"});
    static final List<String> actionWhiteList = new ArrayList<String>();

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
    }

    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
    }

    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
        this.afterExecutionImpl(sqlString);
    }

    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
        this.afterExecutionImpl(sqlString);
    }

    private boolean isMutatingSQL(String sql) {
        String sqlString = sql.toUpperCase();
        return sqlString.startsWith("INSERT") || sqlString.startsWith("UPDATE") || sqlString.startsWith("DELETE");
    }

    private void afterExecutionImpl(String sqlString) {
        if (Boolean.getBoolean("jira.xsrf.diagnostics")) {
            HttpServletRequest request;
            String requestURL = MDC.get((String)"jira.request.url");
            if (this.isMutatingSQL(sqlString) && (request = ActionContext.getRequest()) != null && request.getAttribute(XSRF_VULNERABILITY_DETECTION_SQLINTERCEPTOR_DONE) == null) {
                request.setAttribute(XSRF_VULNERABILITY_DETECTION_SQLINTERCEPTOR_DONE, (Object)"true");
                CallStack callStack = new CallStack();
                boolean showLogMessages = false;
                if (callStack.hasMethodsWeAreInterestedIn()) {
                    showLogMessages = true;
                    if (callStack.isProtectedAction()) {
                        showLogMessages = false;
                    }
                }
                if (showLogMessages) {
                    log.error((Object)"XSRF VULNERABILITY DETECTED");
                    log.error((Object)("requestURL: " + requestURL));
                    log.error((Object)("sql: " + sqlString));
                    log.error((Object)"CallStack:", (Throwable)callStack);
                }
            }
        }
    }

    static {
        if (JiraSystemProperties.isXsrfDetectionCheckRequired()) {
            log.setLevel(Level.INFO);
        }
        LineIterator iterator = IOUtils.lineIterator((Reader)new InputStreamReader(XsrfVulnerabilityDetectionSQLInterceptor.class.getResourceAsStream("/security/xsrf/xsrf-white-list.txt")));
        while (iterator.hasNext()) {
            String line = ((String)iterator.next()).trim();
            if (line.length() <= 0 || line.startsWith("#")) continue;
            actionWhiteList.add(line);
        }
    }

    private static class CallStack
    extends RuntimeException {
        private CallStack() {
        }

        public boolean hasMethodsWeAreInterestedIn() {
            for (StackTraceElement element : this.getStackTrace()) {
                String method = element.getClassName() + "." + element.getMethodName();
                if (!methodsToIgnore.contains(method)) continue;
                return false;
            }
            return true;
        }

        public boolean isProtectedAction() {
            boolean isAnnotated = false;
            StackTraceElement[] elements = this.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement action;
                StackTraceElement element = elements[i];
                if (!this.isActionSupport_execute(element) || (action = this.findActionStackTraceElement(elements, i)) == null) continue;
                String className = action.getClassName();
                try {
                    Class<?> aClass = Class.forName(action.getClassName());
                    Method method = this.getMethod(aClass, action.getMethodName());
                    if (method == null) break;
                    isAnnotated = method.isAnnotationPresent(RequiresXsrfCheck.class);
                    String actionMethodName = action.getMethodName();
                    String actionName = className + "." + actionMethodName;
                    log.info((Object)("ACTION: " + actionName + " PROTECTED: " + isAnnotated));
                    boolean isActionInWhiteList = this.isActionInWhiteList(aClass);
                    if (!isAnnotated) {
                        if (isActionInWhiteList) {
                            throw new RuntimeException("XSRF white list failure");
                        }
                    } else if (!isActionInWhiteList) {
                        throw new RuntimeException("ACTION: " + actionName + " has XSRF annotated but its not in the whitelist");
                    }
                }
                catch (ClassNotFoundException e) {}
                break;
            }
            return isAnnotated;
        }

        private StackTraceElement findActionStackTraceElement(StackTraceElement[] elements, int i) {
            StackTraceElement foundElement = null;
            StackTraceElement element = elements[i - 1];
            if (this.isActionSupport_invokeCommand(element)) {
                for (int j = i; j >= 0; --j) {
                    element = elements[j];
                    if (!this.isActionDoMethod(element)) continue;
                    foundElement = element;
                    break;
                }
            }
            return foundElement;
        }

        private boolean isActionSupport_invokeCommand(StackTraceElement element) {
            return ActionSupport.class.getName().equals(element.getClassName()) && "invokeCommand".equals(element.getMethodName());
        }

        private boolean isActionSupport_execute(StackTraceElement element) {
            return ActionSupport.class.getName().equals(element.getClassName()) && "execute".equals(element.getMethodName());
        }

        private boolean isActionDoMethod(StackTraceElement element) {
            boolean isok = ActionSupport.class.isAssignableFrom(this.getClassOfElement(element));
            isok = isok && element.getMethodName().startsWith("do");
            return isok;
        }

        private Class getClassOfElement(StackTraceElement element) {
            try {
                return Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException e) {
                return e.getClass();
            }
        }

        private boolean isActionInWhiteList(Class<?> aClass) {
            boolean isActionInWhiteList = actionWhiteList.contains(aClass.getName());
            if (!isActionInWhiteList) {
                isActionInWhiteList = actionWhiteList.contains(aClass.getSimpleName());
            }
            return isActionInWhiteList;
        }

        private Method getMethod(Class clazz, String methodName) {
            try {
                return clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (clazz.equals(JiraWebActionSupport.class) || clazz.equals(Object.class)) {
                    return null;
                }
                return this.getMethod(clazz.getSuperclass(), methodName);
            }
        }
    }
}

