/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class XsrfErrorAction
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger(XsrfErrorAction.class);
    final XsrfFailureException xsrfFailureException;

    public XsrfErrorAction(XsrfFailureException xsrfFailureException) {
        this.xsrfFailureException = xsrfFailureException;
        User user = this.getAuthContext().getLoggedInUser();
        if (user != null) {
            this.request.setAttribute("loggedin", (Object)Boolean.TRUE);
        }
        this.request.setAttribute("xsrfToken", (Object)this.getXsrfToken());
        this.request.setAttribute("maxInactiveIntervalMinutes", (Object)(this.request.getSession(true).getMaxInactiveInterval() / 60));
        this.request.setAttribute("contextpath", (Object)this.request.getContextPath());
        this.request.setAttribute("helpUtil", (Object)new HelpUtil());
        int parameterCount = this.getRequestParameters().size();
        log.info((Object)("The security token is missing for '" + (Users.isAnonymous((User)user) ? "anonymous" : user.getName()) + "'. " + (parameterCount == 0 ? "The browser has provided ZERO parameters.  Probably BUG! " : "") + "User-Agent : '" + this.getBrowserAgent(this.request) + "'"));
    }

    private String getBrowserAgent(HttpServletRequest request) {
        return StringUtils.defaultIfEmpty((String)request.getHeader("User-Agent"), (String)"Not Provided");
    }

    private JiraAuthenticationContext getAuthContext() {
        return ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class);
    }

    public XsrfFailureException getException() {
        return this.xsrfFailureException;
    }

    public boolean isSessionExpired() {
        return this.xsrfFailureException.isSessionExpired();
    }

    public Action getAction() {
        return this.xsrfFailureException.getAction();
    }

    public String getRequestURL() {
        return this.xsrfFailureException.getRequestURL();
    }

    public String getRequestMethod() {
        return this.xsrfFailureException.getRequestMethod();
    }

    public boolean getNoRequestParameters() {
        return this.getRequestParameters().size() == 0;
    }

    public Set<Map.Entry<String, List<String>>> getRequestParameters() {
        return this.xsrfFailureException.getRequestParameters();
    }
}

